/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.blockentities.RiftStabilizerBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class SyncRiftStabilizer {
    private BlockPos pos;
    private RiftStabilizerBlockEntity.TeleportationType teleportationType;
    private boolean allowed;

    public SyncRiftStabilizer() {
    }

    public SyncRiftStabilizer(BlockPos pos, RiftStabilizerBlockEntity.TeleportationType teleportationType, boolean allowed) {
        this.pos = pos;
        this.teleportationType = teleportationType;
        this.allowed = allowed;
    }

    public static void encode(SyncRiftStabilizer message, FriendlyByteBuf buf) {
        buf.m_130064_(message.pos);
        buf.m_130068_((Enum)message.teleportationType);
        buf.writeBoolean(message.allowed);
    }

    public static SyncRiftStabilizer decode(FriendlyByteBuf buf) {
        SyncRiftStabilizer message = new SyncRiftStabilizer();
        message.pos = buf.m_130135_();
        message.teleportationType = (RiftStabilizerBlockEntity.TeleportationType)buf.m_130066_(RiftStabilizerBlockEntity.TeleportationType.class);
        message.allowed = buf.readBoolean();
        return message;
    }

    public static void onMessage(SyncRiftStabilizer message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (message.teleportationType != null) {
                RiftStabilizerBlockEntity be;
                Level level = ((NetworkEvent.Context)ctx.get()).getSender().f_19853_;
                BlockPos pos = message.pos;
                boolean allowed = message.allowed;
                BlockEntity patt1700$temp = level.m_7702_(pos);
                if (patt1700$temp instanceof RiftStabilizerBlockEntity && (be = (RiftStabilizerBlockEntity)patt1700$temp).isOwnedBy((Player)((NetworkEvent.Context)ctx.get()).getSender())) {
                    BlockState state = level.m_8055_(pos);
                    be.setFilter(message.teleportationType, allowed);
                    level.m_7260_(pos, state, state, 2);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

