/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.animatable;

import javax.annotation.Nullable;
import mod.azure.azurelib.AzureLib;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.network.AzureLibNetwork;
import mod.azure.azurelib.network.SerializableDataTicket;
import mod.azure.azurelib.network.packet.BlockEntityAnimDataSyncPacket;
import mod.azure.azurelib.network.packet.BlockEntityAnimTriggerPacket;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.PacketDistributor;

public interface GeoBlockEntity
extends GeoAnimatable {
    @Nullable
    default public <D> D getAnimData(SerializableDataTicket<D> dataTicket) {
        return this.getAnimatableInstanceCache().getManagerForId(0L).getData(dataTicket);
    }

    default public <D> void setAnimData(SerializableDataTicket<D> dataTicket, D data) {
        BlockEntity blockEntity = (BlockEntity)this;
        Level level = blockEntity.m_58904_();
        if (level == null) {
            AzureLib.LOGGER.error("Attempting to set animation data for BlockEntity too early! Must wait until after the BlockEntity has been set in the world. (" + blockEntity.getClass().toString() + ")");
            return;
        }
        if (level.m_5776_()) {
            this.getAnimatableInstanceCache().getManagerForId(0L).setData(dataTicket, data);
        } else {
            BlockPos pos = blockEntity.m_58899_();
            AzureLibNetwork.send(new BlockEntityAnimDataSyncPacket<D>(pos, dataTicket, data), PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(pos)));
        }
    }

    default public void triggerAnim(@Nullable String controllerName, String animName) {
        BlockEntity blockEntity = (BlockEntity)this;
        Level level = blockEntity.m_58904_();
        if (level == null) {
            AzureLib.LOGGER.error("Attempting to trigger an animation for a BlockEntity too early! Must wait until after the BlockEntity has been set in the world. (" + blockEntity.getClass().toString() + ")");
            return;
        }
        if (level.m_5776_()) {
            this.getAnimatableInstanceCache().getManagerForId(0L).tryTriggerAnimation(controllerName, animName);
        } else {
            BlockPos pos = blockEntity.m_58899_();
            AzureLibNetwork.send(new BlockEntityAnimTriggerPacket(pos, controllerName, animName), PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(pos)));
        }
    }

    @Override
    default public double getTick(Object blockEntity) {
        return RenderUtils.getCurrentTick();
    }
}

