/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.animatable;

import javax.annotation.Nullable;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.network.AzureLibNetwork;
import mod.azure.azurelib.network.SerializableDataTicket;
import mod.azure.azurelib.network.packet.EntityAnimDataSyncPacket;
import mod.azure.azurelib.network.packet.EntityAnimTriggerPacket;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.PacketDistributor;

public interface GeoEntity
extends GeoAnimatable {
    @Nullable
    default public <D> D getAnimData(SerializableDataTicket<D> dataTicket) {
        return this.getAnimatableInstanceCache().getManagerForId(((Entity)this).m_19879_()).getData(dataTicket);
    }

    default public <D> void setAnimData(SerializableDataTicket<D> dataTicket, D data) {
        Entity entity = (Entity)this;
        if (entity.m_9236_().m_5776_()) {
            this.getAnimatableInstanceCache().getManagerForId(entity.m_19879_()).setData(dataTicket, data);
        } else {
            AzureLibNetwork.send(new EntityAnimDataSyncPacket<D>(entity.m_19879_(), dataTicket, data), PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity));
        }
    }

    default public void triggerAnim(@Nullable String controllerName, String animName) {
        Entity entity = (Entity)this;
        if (entity.m_9236_().m_5776_()) {
            this.getAnimatableInstanceCache().getManagerForId(entity.m_19879_()).tryTriggerAnimation(controllerName, animName);
        } else {
            AzureLibNetwork.send(new EntityAnimTriggerPacket(entity.m_19879_(), controllerName, animName), PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity));
        }
    }

    @Override
    default public double getTick(Object entity) {
        return RenderUtils.getCurrentTick();
    }
}

