/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.animatable;

import java.util.EnumMap;
import java.util.Map;
import mod.azure.azurelib.animatable.SingletonGeoAnimatable;
import mod.azure.azurelib.cache.AnimatableIdCache;
import mod.azure.azurelib.constant.DataTickets;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animatable.instance.SingletonAnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.ContextAwareAnimatableManager;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public interface GeoItem
extends SingletonGeoAnimatable {
    public static final String ID_NBT_KEY = "AzureLibID";

    public static long getId(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return Long.MAX_VALUE;
        }
        return tag.m_128454_(ID_NBT_KEY);
    }

    public static long getOrAssignId(ItemStack stack, ServerLevel level) {
        CompoundTag tag = stack.m_41784_();
        long id = tag.m_128454_(ID_NBT_KEY);
        if (tag.m_128425_(ID_NBT_KEY, 99)) {
            return id;
        }
        id = AnimatableIdCache.getFreeId(level);
        tag.m_128356_(ID_NBT_KEY, id);
        return id;
    }

    @Override
    default public double getTick(Object itemStack) {
        return RenderUtils.getCurrentTick();
    }

    default public boolean isPerspectiveAware() {
        return false;
    }

    @Override
    @Nullable
    default public AnimatableInstanceCache animatableCacheOverride() {
        if (this.isPerspectiveAware()) {
            return new ContextBasedAnimatableInstanceCache(this);
        }
        return SingletonGeoAnimatable.super.animatableCacheOverride();
    }

    public static class ContextBasedAnimatableInstanceCache
    extends SingletonAnimatableInstanceCache {
        public ContextBasedAnimatableInstanceCache(GeoAnimatable animatable) {
            super(animatable);
        }

        @Override
        public AnimatableManager<?> getManagerForId(long uniqueId) {
            if (!this.managers.containsKey(uniqueId)) {
                this.managers.put(uniqueId, (Object)new ContextAwareAnimatableManager<GeoItem, ItemTransforms.TransformType>(this.animatable){

                    @Override
                    protected Map<ItemTransforms.TransformType, AnimatableManager<GeoItem>> buildContextOptions(GeoAnimatable animatable) {
                        EnumMap<ItemTransforms.TransformType, AnimatableManager<GeoItem>> map = new EnumMap<ItemTransforms.TransformType, AnimatableManager<GeoItem>>(ItemTransforms.TransformType.class);
                        for (ItemTransforms.TransformType context : ItemTransforms.TransformType.values()) {
                            map.put(context, new AnimatableManager(animatable));
                        }
                        return map;
                    }

                    @Override
                    public ItemTransforms.TransformType getCurrentContext() {
                        // Could not load outer class - annotation placement on inner may be incorrect
                         @Nullable ItemTransforms.TransformType context = this.getData(DataTickets.ITEM_RENDER_PERSPECTIVE);
                        return context == null ? ItemTransforms.TransformType.NONE : context;
                    }
                });
            }
            return (AnimatableManager)this.managers.get(uniqueId);
        }
    }
}

