/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.constant;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import mod.azure.azurelib.AzureLib;
import mod.azure.azurelib.core.object.DataTicket;
import mod.azure.azurelib.model.data.EntityModelData;
import mod.azure.azurelib.network.SerializableDataTicket;
import mod.azure.azurelib.util.AzureLibUtil;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class DataTickets {
    private static final Map<String, SerializableDataTicket<?>> SERIALIZABLE_TICKETS = new ConcurrentHashMap();
    public static final DataTicket<BlockEntity> BLOCK_ENTITY = new DataTicket<BlockEntity>("block_entity", BlockEntity.class);
    public static final DataTicket<ItemStack> ITEMSTACK = new DataTicket<ItemStack>("itemstack", ItemStack.class);
    public static final DataTicket<Entity> ENTITY = new DataTicket<Entity>("entity", Entity.class);
    public static final DataTicket<EquipmentSlot> EQUIPMENT_SLOT = new DataTicket<EquipmentSlot>("equipment_slot", EquipmentSlot.class);
    public static final DataTicket<EntityModelData> ENTITY_MODEL_DATA = new DataTicket<EntityModelData>("entity_model_data", EntityModelData.class);
    public static final DataTicket<Double> TICK = new DataTicket<Double>("tick", Double.class);
    public static final DataTicket<ItemTransforms.TransformType> ITEM_RENDER_PERSPECTIVE = new DataTicket<ItemTransforms.TransformType>("item_render_perspective", ItemTransforms.TransformType.class);
    public static final SerializableDataTicket<Integer> ANIM_STATE = AzureLibUtil.addDataTicket(SerializableDataTicket.ofInt(new ResourceLocation("azurelib", "anim_state")));
    public static final SerializableDataTicket<String> ANIM = AzureLibUtil.addDataTicket(SerializableDataTicket.ofString(new ResourceLocation("azurelib", "anim")));
    public static final SerializableDataTicket<Integer> USE_TICKS = AzureLibUtil.addDataTicket(SerializableDataTicket.ofInt(new ResourceLocation("azurelib", "use_ticks")));
    public static final SerializableDataTicket<Boolean> ACTIVE = AzureLibUtil.addDataTicket(SerializableDataTicket.ofBoolean(new ResourceLocation("azurelib", "active")));
    public static final SerializableDataTicket<Boolean> OPEN = AzureLibUtil.addDataTicket(SerializableDataTicket.ofBoolean(new ResourceLocation("azurelib", "open")));
    public static final SerializableDataTicket<Boolean> CLOSED = AzureLibUtil.addDataTicket(SerializableDataTicket.ofBoolean(new ResourceLocation("azurelib", "closed")));
    public static final SerializableDataTicket<Direction> DIRECTION = AzureLibUtil.addDataTicket(SerializableDataTicket.ofEnum(new ResourceLocation("azurelib", "direction"), Direction.class));

    @Nullable
    public static SerializableDataTicket<?> byName(String id) {
        return SERIALIZABLE_TICKETS.getOrDefault(id, null);
    }

    public static <D> SerializableDataTicket<D> registerSerializable(SerializableDataTicket<D> ticket) {
        SerializableDataTicket<D> existingTicket = SERIALIZABLE_TICKETS.putIfAbsent(ticket.id(), ticket);
        if (existingTicket != null) {
            AzureLib.LOGGER.error("Duplicate SerializableDataTicket registered! This will cause issues. Existing: " + existingTicket.id() + ", New: " + ticket.id());
        }
        return ticket;
    }
}

