/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.helper;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.Registry;
import net.minecraft.core.UUIDUtil;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record AzureVibrationInfo(GameEvent gameEvent, float distance, Vec3 pos, @Nullable UUID uuid, @Nullable UUID projectileOwnerUuid, @Nullable Entity entity) {
    public static final Codec<AzureVibrationInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Registry.f_175412_.m_194605_().fieldOf("game_event").forGetter(AzureVibrationInfo::gameEvent), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).fieldOf("distance").forGetter(AzureVibrationInfo::distance), (App)Vec3.f_231074_.fieldOf("pos").forGetter(AzureVibrationInfo::pos), (App)UUIDUtil.f_235867_.optionalFieldOf("source").forGetter(vibrationInfo -> Optional.ofNullable(vibrationInfo.uuid())), (App)UUIDUtil.f_235867_.optionalFieldOf("projectile_owner").forGetter(vibrationInfo -> Optional.ofNullable(vibrationInfo.projectileOwnerUuid()))).apply((Applicative)instance, (gameEvent, float_, vec3, optional, optional2) -> new AzureVibrationInfo((GameEvent)gameEvent, float_.floatValue(), (Vec3)vec3, optional.orElse(null), optional2.orElse(null))));

    public AzureVibrationInfo(GameEvent gameEvent, float f, Vec3 vec3, @Nullable UUID uUID, @Nullable UUID uUID2) {
        this(gameEvent, f, vec3, uUID, uUID2, null);
    }

    public AzureVibrationInfo(GameEvent gameEvent, float f, Vec3 vec3, @Nullable Entity entity) {
        this(gameEvent, f, vec3, entity == null ? null : entity.m_20148_(), AzureVibrationInfo.getProjectileOwner(entity), entity);
    }

    @Nullable
    private static UUID getProjectileOwner(@Nullable Entity entity) {
        Projectile projectile;
        if (entity instanceof Projectile && (projectile = (Projectile)entity).m_37282_() != null) {
            return projectile.m_37282_().m_20148_();
        }
        return null;
    }

    public Optional<Entity> getEntity(ServerLevel serverLevel) {
        return Optional.ofNullable(this.entity).or(() -> Optional.ofNullable(this.uuid).map(arg_0 -> ((ServerLevel)serverLevel).m_8791_(arg_0)));
    }

    public Optional<Entity> getProjectileOwner(ServerLevel serverLevel) {
        return this.getEntity(serverLevel).filter(entity -> entity instanceof Projectile).map(entity -> (Projectile)entity).map(Projectile::m_37282_).or(() -> Optional.ofNullable(this.projectileOwnerUuid).map(arg_0 -> ((ServerLevel)serverLevel).m_8791_(arg_0)));
    }
}

