/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.helper;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Optional;
import mod.azure.azurelib.helper.AzureVibrationInfo;
import mod.azure.azurelib.helper.AzureVibrationSelector;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipBlockStateContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class AzureVibrationListener
implements GameEventListener {
    @VisibleForTesting
    public static final Object2IntMap<GameEvent> VIBRATION_FREQUENCY_FOR_EVENT = Object2IntMaps.unmodifiable((Object2IntMap)((Object2IntMap)Util.m_137469_((Object)new Object2IntOpenHashMap(), object2IntOpenHashMap -> {
        object2IntOpenHashMap.put((Object)GameEvent.f_157785_, 1);
        object2IntOpenHashMap.put((Object)GameEvent.f_157815_, 2);
        object2IntOpenHashMap.put((Object)GameEvent.f_157786_, 3);
        object2IntOpenHashMap.put((Object)GameEvent.f_223705_, 4);
        object2IntOpenHashMap.put((Object)GameEvent.f_157770_, 5);
        object2IntOpenHashMap.put((Object)GameEvent.f_238175_, 5);
        object2IntOpenHashMap.put((Object)GameEvent.f_157784_, 6);
        object2IntOpenHashMap.put((Object)GameEvent.f_223710_, 6);
        object2IntOpenHashMap.put((Object)GameEvent.f_157792_, 6);
        object2IntOpenHashMap.put((Object)GameEvent.f_223699_, 6);
        object2IntOpenHashMap.put((Object)GameEvent.f_157778_, 7);
        object2IntOpenHashMap.put((Object)GameEvent.f_223704_, 7);
        object2IntOpenHashMap.put((Object)GameEvent.f_157776_, 7);
        object2IntOpenHashMap.put((Object)GameEvent.f_157777_, 8);
        object2IntOpenHashMap.put((Object)GameEvent.f_157806_, 8);
        object2IntOpenHashMap.put((Object)GameEvent.f_223708_, 8);
        object2IntOpenHashMap.put((Object)GameEvent.f_223706_, 8);
        object2IntOpenHashMap.put((Object)GameEvent.f_157811_, 9);
        object2IntOpenHashMap.put((Object)GameEvent.f_157781_, 9);
        object2IntOpenHashMap.put((Object)GameEvent.f_223709_, 9);
        object2IntOpenHashMap.put((Object)GameEvent.f_157793_, 10);
        object2IntOpenHashMap.put((Object)GameEvent.f_223703_, 10);
        object2IntOpenHashMap.put((Object)GameEvent.f_157795_, 10);
        object2IntOpenHashMap.put((Object)GameEvent.f_157804_, 10);
        object2IntOpenHashMap.put((Object)GameEvent.f_157796_, 11);
        object2IntOpenHashMap.put((Object)GameEvent.f_223702_, 11);
        object2IntOpenHashMap.put((Object)GameEvent.f_157791_, 11);
        object2IntOpenHashMap.put((Object)GameEvent.f_157810_, 12);
        object2IntOpenHashMap.put((Object)GameEvent.f_157797_, 12);
        object2IntOpenHashMap.put((Object)GameEvent.f_157769_, 12);
        object2IntOpenHashMap.put((Object)GameEvent.f_223707_, 13);
        object2IntOpenHashMap.put((Object)GameEvent.f_157794_, 13);
        object2IntOpenHashMap.put((Object)GameEvent.f_157816_, 13);
        object2IntOpenHashMap.put((Object)GameEvent.f_223697_, 14);
        object2IntOpenHashMap.put((Object)GameEvent.f_157802_, 14);
        object2IntOpenHashMap.put((Object)GameEvent.f_157774_, 14);
        object2IntOpenHashMap.put((Object)GameEvent.f_157775_, 15);
        object2IntOpenHashMap.put((Object)GameEvent.f_157803_, 15);
        object2IntOpenHashMap.put((Object)GameEvent.f_157812_, 15);
        object2IntOpenHashMap.put((Object)GameEvent.f_157772_, 15);
        object2IntOpenHashMap.put((Object)GameEvent.f_223696_, 15);
    })));
    protected final PositionSource listenerSource;
    protected final int listenerRange;
    protected final AzureVibrationListenerConfig config;
    @Nullable
    protected AzureVibrationInfo currentVibration;
    protected int travelTimeInTicks;
    private final AzureVibrationSelector selectionStrategy;

    public static Codec<AzureVibrationListener> codec(AzureVibrationListenerConfig vibrationListenerConfig) {
        return RecordCodecBuilder.create(instance -> instance.group((App)PositionSource.f_157868_.fieldOf("source").forGetter(vibrationListener -> vibrationListener.listenerSource), (App)ExtraCodecs.f_144628_.fieldOf("range").forGetter(vibrationListener -> vibrationListener.listenerRange), (App)AzureVibrationInfo.CODEC.optionalFieldOf("event").forGetter(vibrationListener -> Optional.ofNullable(vibrationListener.currentVibration)), (App)AzureVibrationSelector.CODEC.fieldOf("selector").forGetter(vibrationListener -> vibrationListener.selectionStrategy), (App)ExtraCodecs.f_144628_.fieldOf("event_delay").orElse((Object)0).forGetter(vibrationListener -> vibrationListener.travelTimeInTicks)).apply((Applicative)instance, (positionSource, integer, optional, vibrationSelector, integer2) -> new AzureVibrationListener((PositionSource)positionSource, (int)integer, vibrationListenerConfig, optional.orElse(null), (AzureVibrationSelector)vibrationSelector, (int)integer2)));
    }

    public AzureVibrationListener(PositionSource positionSource, int i, AzureVibrationListenerConfig vibrationListenerConfig, @Nullable AzureVibrationInfo vibrationInfo, AzureVibrationSelector vibrationSelector, int j) {
        this.listenerSource = positionSource;
        this.listenerRange = i;
        this.config = vibrationListenerConfig;
        this.currentVibration = vibrationInfo;
        this.travelTimeInTicks = j;
        this.selectionStrategy = vibrationSelector;
    }

    public AzureVibrationListener(PositionSource positionSource, int i, AzureVibrationListenerConfig vibrationListenerConfig) {
        this(positionSource, i, vibrationListenerConfig, null, new AzureVibrationSelector(), 0);
    }

    public static int getGameEventFrequency(GameEvent gameEvent) {
        return VIBRATION_FREQUENCY_FOR_EVENT.getOrDefault((Object)gameEvent, 0);
    }

    public void tick(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.currentVibration == null) {
                this.selectionStrategy.chosenCandidate(serverLevel.m_46467_()).ifPresent(vibrationInfo -> {
                    this.currentVibration = vibrationInfo;
                    this.travelTimeInTicks = Mth.m_14143_((float)this.currentVibration.distance());
                    this.config.onSignalSchedule();
                    this.selectionStrategy.startOver();
                });
            }
            if (this.currentVibration != null) {
                --this.travelTimeInTicks;
                if (this.travelTimeInTicks <= 0) {
                    this.travelTimeInTicks = 0;
                    this.config.onSignalReceive(serverLevel, this, new BlockPos(this.currentVibration.pos()), this.currentVibration.gameEvent(), this.currentVibration.getEntity(serverLevel).orElse(null), this.currentVibration.getProjectileOwner(serverLevel).orElse(null), this.currentVibration.distance());
                    this.currentVibration = null;
                }
            }
        }
    }

    public PositionSource m_142460_() {
        return this.listenerSource;
    }

    public int m_142078_() {
        return this.listenerRange;
    }

    public boolean m_214068_(ServerLevel level, GameEvent.Message eventMessage) {
        GameEvent.Context context;
        if (this.currentVibration != null) {
            return false;
        }
        GameEvent gameEvent = eventMessage.m_223740_();
        if (!this.config.isValidVibration(gameEvent, context = eventMessage.m_223744_())) {
            return false;
        }
        Optional optional = this.listenerSource.m_142502_((Level)level);
        if (optional.isEmpty()) {
            return false;
        }
        Vec3 vec3 = eventMessage.m_223743_();
        Vec3 vec32 = (Vec3)optional.get();
        if (!this.config.shouldListen(level, this, new BlockPos(vec3), gameEvent, context)) {
            return false;
        }
        if (AzureVibrationListener.isOccluded((Level)level, vec3, vec32)) {
            return false;
        }
        this.scheduleVibration(level, gameEvent, context, vec3, vec32);
        return true;
    }

    public void forceGameEvent(ServerLevel serverLevel, GameEvent gameEvent, GameEvent.Context context, Vec3 vec3) {
        this.listenerSource.m_142502_((Level)serverLevel).ifPresent(vec32 -> this.scheduleVibration(serverLevel, gameEvent, context, vec3, (Vec3)vec32));
    }

    public void scheduleVibration(ServerLevel serverLevel, GameEvent gameEvent, GameEvent.Context context, Vec3 vec3, Vec3 vec32) {
        this.selectionStrategy.addCandidate(new AzureVibrationInfo(gameEvent, (float)vec3.m_82554_(vec32), vec3, context.f_223711_()), serverLevel.m_46467_());
    }

    private static boolean isOccluded(Level level, Vec3 vec3, Vec3 vec32) {
        Vec3 vec33 = new Vec3((double)Mth.m_14107_((double)vec3.f_82479_) + 0.5, (double)Mth.m_14107_((double)vec3.f_82480_) + 0.5, (double)Mth.m_14107_((double)vec3.f_82481_) + 0.5);
        Vec3 vec34 = new Vec3((double)Mth.m_14107_((double)vec32.f_82479_) + 0.5, (double)Mth.m_14107_((double)vec32.f_82480_) + 0.5, (double)Mth.m_14107_((double)vec32.f_82481_) + 0.5);
        for (Direction direction : Direction.values()) {
            Vec3 vec35 = vec33.m_231075_(direction, (double)1.0E-5f);
            if (level.m_151353_(new ClipBlockStateContext(vec35, vec34, blockState -> blockState.m_204336_(BlockTags.f_144272_))).m_6662_() == HitResult.Type.BLOCK) continue;
            return false;
        }
        return true;
    }

    public static interface AzureVibrationListenerConfig {
        default public TagKey<GameEvent> getListenableEvents() {
            return GameEventTags.f_215853_;
        }

        default public boolean canTriggerAvoidVibration() {
            return true;
        }

        default public boolean isValidVibration(GameEvent event, GameEvent.Context context) {
            if (!event.m_204528_(this.getListenableEvents())) {
                return false;
            }
            Entity entity = context.f_223711_();
            if (entity != null) {
                if (entity.m_5833_()) {
                    return false;
                }
                if (entity.m_20161_() && event.m_204528_(GameEventTags.f_144303_)) {
                    return false;
                }
            }
            if (context.f_223712_() != null) {
                return !context.f_223712_().m_204336_(BlockTags.f_215836_);
            }
            return true;
        }

        public boolean shouldListen(ServerLevel var1, GameEventListener var2, BlockPos var3, GameEvent var4, GameEvent.Context var5);

        public void onSignalReceive(ServerLevel var1, GameEventListener var2, BlockPos var3, GameEvent var4, @Nullable Entity var5, @Nullable Entity var6, float var7);

        default public void onSignalSchedule() {
        }
    }
}

