/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.helper;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import mod.azure.azurelib.helper.AzureVibrationInfo;
import mod.azure.azurelib.helper.AzureVibrationListener;
import org.apache.commons.lang3.tuple.Pair;

public class AzureVibrationSelector {
    public static final Codec<AzureVibrationSelector> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)AzureVibrationInfo.CODEC.optionalFieldOf("event").forGetter(vibrationSelector -> vibrationSelector.currentVibrationData.map(Pair::getLeft)), (App)Codec.LONG.fieldOf("tick").forGetter(vibrationSelector -> vibrationSelector.currentVibrationData.map(Pair::getRight).orElse(-1L))).apply((Applicative)instance, AzureVibrationSelector::new));
    private Optional<Pair<AzureVibrationInfo, Long>> currentVibrationData;

    public AzureVibrationSelector(Optional<AzureVibrationInfo> optional, long l) {
        this.currentVibrationData = optional.map(vibrationInfo -> Pair.of((Object)vibrationInfo, (Object)l));
    }

    public AzureVibrationSelector() {
        this.currentVibrationData = Optional.empty();
    }

    public void addCandidate(AzureVibrationInfo vibrationInfo, long l) {
        if (this.shouldReplaceVibration(vibrationInfo, l)) {
            this.currentVibrationData = Optional.of(Pair.of((Object)vibrationInfo, (Object)l));
        }
    }

    private boolean shouldReplaceVibration(AzureVibrationInfo vibrationInfo, long l) {
        if (this.currentVibrationData.isEmpty()) {
            return true;
        }
        Pair<AzureVibrationInfo, Long> pair = this.currentVibrationData.get();
        Long m = (Long)pair.getRight();
        if (l != m) {
            return false;
        }
        AzureVibrationInfo vibrationInfo2 = (AzureVibrationInfo)pair.getLeft();
        if (vibrationInfo.distance() < vibrationInfo2.distance()) {
            return true;
        }
        if (vibrationInfo.distance() > vibrationInfo2.distance()) {
            return false;
        }
        return AzureVibrationListener.getGameEventFrequency(vibrationInfo.gameEvent()) > AzureVibrationListener.getGameEventFrequency(vibrationInfo2.gameEvent());
    }

    public Optional<AzureVibrationInfo> chosenCandidate(long l) {
        if (this.currentVibrationData.isEmpty()) {
            return Optional.empty();
        }
        if ((Long)this.currentVibrationData.get().getRight() < l) {
            return Optional.of((AzureVibrationInfo)this.currentVibrationData.get().getLeft());
        }
        return Optional.empty();
    }

    public void startOver() {
        this.currentVibrationData = Optional.empty();
    }
}

