/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.network.packet;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.animatable.GeoReplacedEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.util.ClientUtils;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class EntityAnimTriggerPacket<D> {
    private final int entityId;
    private final boolean isReplacedEntity;
    private final String controllerName;
    private final String animName;

    public EntityAnimTriggerPacket(int entityId, @Nullable String controllerName, String animName) {
        this(entityId, false, controllerName, animName);
    }

    public EntityAnimTriggerPacket(int entityId, boolean isReplacedEntity, @Nullable String controllerName, String animName) {
        this.entityId = entityId;
        this.isReplacedEntity = isReplacedEntity;
        this.controllerName = controllerName == null ? "" : controllerName;
        this.animName = animName;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.entityId);
        buffer.writeBoolean(this.isReplacedEntity);
        buffer.m_130070_(this.controllerName);
        buffer.m_130070_(this.animName);
    }

    public static <D> EntityAnimTriggerPacket<D> decode(FriendlyByteBuf buffer) {
        return new EntityAnimTriggerPacket<D>(buffer.m_130242_(), buffer.readBoolean(), buffer.m_130277_(), buffer.m_130277_());
    }

    public void receivePacket(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context handler = context.get();
        handler.enqueueWork(() -> {
            Entity entity = ClientUtils.getLevel().m_6815_(this.entityId);
            if (entity == null) {
                return;
            }
            if (this.isReplacedEntity) {
                GeoAnimatable animatable = RenderUtils.getReplacedAnimatable(entity.m_6095_());
                if (animatable instanceof GeoReplacedEntity) {
                    GeoReplacedEntity replacedEntity = (GeoReplacedEntity)animatable;
                    replacedEntity.triggerAnim(entity, this.controllerName.isEmpty() ? null : this.controllerName, this.animName);
                }
            } else if (entity instanceof GeoEntity) {
                GeoEntity geoEntity = (GeoEntity)entity;
                geoEntity.triggerAnim(this.controllerName.isEmpty() ? null : this.controllerName, this.animName);
            }
        });
        handler.setPacketHandled(true);
    }
}

