/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.renderer.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import mod.azure.azurelib.cache.object.GeoBone;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.renderer.GeoRenderer;
import mod.azure.azurelib.renderer.layer.GeoRenderLayer;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;

public class BlockAndItemGeoLayer<T extends GeoAnimatable>
extends GeoRenderLayer<T> {
    protected final BiFunction<GeoBone, T, ItemStack> stackForBone;
    protected final BiFunction<GeoBone, T, BlockState> blockForBone;

    public BlockAndItemGeoLayer(GeoRenderer<T> renderer) {
        this(renderer, (bone, animatable) -> null, (bone, animatable) -> null);
    }

    public BlockAndItemGeoLayer(GeoRenderer<T> renderer, BiFunction<GeoBone, T, ItemStack> stackForBone, BiFunction<GeoBone, T, BlockState> blockForBone) {
        super(renderer);
        this.stackForBone = stackForBone;
        this.blockForBone = blockForBone;
    }

    @Nullable
    protected ItemStack getStackForBone(GeoBone bone, T animatable) {
        return this.stackForBone.apply(bone, (GeoBone)animatable);
    }

    @Nullable
    protected BlockState getBlockForBone(GeoBone bone, T animatable) {
        return this.blockForBone.apply(bone, (GeoBone)animatable);
    }

    protected ItemTransforms.TransformType getTransformTypeForStack(GeoBone bone, ItemStack stack, T animatable) {
        return ItemTransforms.TransformType.NONE;
    }

    @Override
    public void renderForBone(PoseStack poseStack, T animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        ItemStack stack = this.getStackForBone(bone, animatable);
        BlockState blockState = this.getBlockForBone(bone, animatable);
        if (stack == null && blockState == null) {
            return;
        }
        poseStack.m_85836_();
        RenderUtils.translateAndRotateMatrixForBone(poseStack, bone);
        if (stack != null) {
            this.renderStackForBone(poseStack, bone, stack, animatable, bufferSource, partialTick, packedLight, packedOverlay);
        }
        if (blockState != null) {
            this.renderBlockForBone(poseStack, bone, blockState, animatable, bufferSource, partialTick, packedLight, packedOverlay);
        }
        buffer = bufferSource.m_6299_(renderType);
        poseStack.m_85849_();
    }

    protected void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, T animatable, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
        if (animatable instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)animatable;
            Minecraft.m_91087_().m_91291_().m_174242_(livingEntity, stack, this.getTransformTypeForStack(bone, stack, animatable), false, poseStack, bufferSource, livingEntity.f_19853_, packedLight, packedOverlay, livingEntity.m_19879_());
        } else {
            Minecraft.m_91087_().m_91291_().m_174269_(stack, this.getTransformTypeForStack(bone, stack, animatable), packedLight, packedOverlay, poseStack, bufferSource, (int)this.renderer.getInstanceId(animatable));
        }
    }

    protected void renderBlockForBone(PoseStack poseStack, GeoBone bone, BlockState state, T animatable, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
        poseStack.m_85836_();
        poseStack.m_85837_(-0.25, -0.25, -0.25);
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        Minecraft.m_91087_().m_91289_().renderSingleBlock(state, poseStack, bufferSource, packedLight, packedOverlay, ModelData.EMPTY, null);
        poseStack.m_85849_();
    }
}

