/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen;

import java.util.Random;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.varia.ChunkCoord;
import mcjty.lostcities.worldgen.ChunkHeightmap;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.LostCityTerrainFeature;
import mcjty.lostcities.worldgen.lost.cityassets.AssetRegistries;
import mcjty.lostcities.worldgen.lost.cityassets.WorldStyle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import org.jetbrains.annotations.Nullable;

public class DefaultDimensionInfo
implements IDimensionInfo {
    private WorldGenLevel world;
    private final LostCityProfile profile;
    private final LostCityProfile profileOutside;
    private final WorldStyle style;
    private final Random random;
    private final Registry<Biome> biomeRegistry;
    private final LostCityTerrainFeature feature;

    public DefaultDimensionInfo(WorldGenLevel world, LostCityProfile profile, LostCityProfile profileOutside) {
        this.world = world;
        this.profile = profile;
        this.profileOutside = profileOutside;
        this.style = AssetRegistries.WORLDSTYLES.get((CommonLevelAccessor)world, profile.getWorldStyle());
        this.random = new Random(world.m_7328_());
        LegacyRandomSource randomSource = new LegacyRandomSource(world.m_7328_());
        this.feature = new LostCityTerrainFeature(this, profile, (RandomSource)randomSource);
        this.feature.setupStates(profile);
        this.biomeRegistry = (Registry)RegistryAccess.m_206197_().m_6632_(Registry.f_122885_).get();
    }

    @Override
    public void setWorld(WorldGenLevel world) {
        this.world = world;
    }

    @Override
    public long getSeed() {
        return this.world.m_7328_();
    }

    @Override
    public WorldGenLevel getWorld() {
        return this.world;
    }

    @Override
    public ResourceKey<Level> getType() {
        return this.world.m_6018_().m_46472_();
    }

    @Override
    public LostCityProfile getProfile() {
        return this.profile;
    }

    @Override
    public LostCityProfile getOutsideProfile() {
        return this.profileOutside;
    }

    @Override
    public WorldStyle getWorldStyle() {
        return this.style;
    }

    @Override
    public Random getRandom() {
        return this.random;
    }

    @Override
    public LostCityTerrainFeature getFeature() {
        return this.feature;
    }

    @Override
    public ChunkHeightmap getHeightmap(int chunkX, int chunkZ) {
        ChunkCoord coord = new ChunkCoord(this.getType(), chunkX, chunkZ);
        return this.feature.getHeightmap(coord, this.getWorld());
    }

    @Override
    public ChunkHeightmap getHeightmap(ChunkCoord coord) {
        return this.feature.getHeightmap(coord, this.getWorld());
    }

    @Override
    public Holder<Biome> getBiome(BlockPos pos) {
        ChunkSource chunkProvider = this.getWorld().m_7726_();
        if (chunkProvider instanceof ServerChunkCache) {
            ChunkGenerator generator = ((ServerChunkCache)chunkProvider).m_8481_();
            BiomeSource biomeProvider = generator.m_62218_();
            Climate.Sampler sampler = ((ServerChunkCache)chunkProvider).m_214994_().m_224579_();
            return biomeProvider.m_203407_(pos.m_123341_() >> 2, pos.m_123342_() >> 2, pos.m_123343_() >> 2, sampler);
        }
        return this.biomeRegistry.m_206081_(Biomes.f_48202_);
    }

    @Override
    @Nullable
    public ResourceKey<Level> dimension() {
        return this.world.m_6018_().m_46472_();
    }
}

