/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import mcjty.lostcities.LostCities;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.config.ProfileSetup;
import mcjty.lostcities.setup.Config;
import mcjty.lostcities.setup.ForgeEventHandlers;
import mcjty.lostcities.worldgen.DefaultDimensionInfo;
import mcjty.lostcities.worldgen.ErrorLogger;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.lost.cityassets.AssetRegistries;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraftforge.common.Tags;

public class LostCityFeature
extends Feature<NoneFeatureConfiguration> {
    private final Map<ResourceKey<Level>, IDimensionInfo> dimensionInfo = new HashMap<ResourceKey<Level>, IDimensionInfo>();
    public static int globalDimensionInfoDirtyCounter = 0;
    private int dimensionInfoDirtyCounter = -1;

    public LostCityFeature() {
        super(NoneFeatureConfiguration.f_67815_);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        IDimensionInfo diminfo;
        WorldGenLevel level = context.m_159774_();
        if (level instanceof WorldGenRegion && (diminfo = this.getDimensionInfo(level)) != null) {
            WorldGenRegion region = (WorldGenRegion)level;
            ChunkPos center = region.m_143488_();
            Holder biome = region.m_204166_(center.m_151394_(60));
            if (biome.m_203656_(Tags.Biomes.IS_VOID)) {
                return false;
            }
            int chunkX = center.f_45578_;
            int chunkZ = center.f_45579_;
            diminfo.setWorld(level);
            try {
                diminfo.getFeature().generate(region, region.m_6325_(chunkX, chunkZ));
            }
            catch (Exception e) {
                LostCities.getLogger().error("Error generating chunk {},{}: {}", (Object)chunkX, (Object)chunkZ, (Object)e.getMessage(), (Object)e);
                e.printStackTrace();
                ErrorLogger.logChunkInfo(chunkX, chunkZ, diminfo);
                ErrorLogger.report("There was an error generating a chunk. See log for details!");
            }
            return true;
        }
        return false;
    }

    @Nullable
    public IDimensionInfo getDimensionInfo(WorldGenLevel world) {
        ResourceKey type;
        String profileName;
        if (globalDimensionInfoDirtyCounter != this.dimensionInfoDirtyCounter) {
            this.cleanUp();
        }
        if ((profileName = Config.getProfileForDimension((ResourceKey<Level>)(type = world.m_6018_().m_46472_()))) != null) {
            if (!this.dimensionInfo.containsKey(type)) {
                LostCityProfile profile = ProfileSetup.STANDARD_PROFILES.get(profileName);
                if (profile == null) {
                    return null;
                }
                LostCityProfile outsideProfile = profile.CITYSPHERE_OUTSIDE_PROFILE == null ? null : ProfileSetup.STANDARD_PROFILES.get(profile.CITYSPHERE_OUTSIDE_PROFILE);
                DefaultDimensionInfo diminfo = new DefaultDimensionInfo(world, profile, outsideProfile);
                this.dimensionInfo.put((ResourceKey<Level>)type, diminfo);
            }
            return this.dimensionInfo.get(type);
        }
        return null;
    }

    public void cleanUp() {
        LostCities.lostCitiesImp.cleanUp();
        ForgeEventHandlers.cleanUp();
        AssetRegistries.reset();
        this.dimensionInfo.clear();
        this.dimensionInfoDirtyCounter = globalDimensionInfoDirtyCounter;
    }
}

