/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost.regassets.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockMatcher
implements Predicate<BlockState> {
    private final Optional<List<String>> ifAll;
    private final Optional<List<String>> ifAny;
    private final Optional<List<String>> excluding;
    private final Predicate<BlockState> predicate;
    public static final Codec<BlockMatcher> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)Codec.STRING.listOf().optionalFieldOf("if_all").forGetter(BlockMatcher::getIfAll), (App)Codec.STRING.listOf().optionalFieldOf("if_any").forGetter(BlockMatcher::getIfAny), (App)Codec.STRING.listOf().optionalFieldOf("excluding").forGetter(BlockMatcher::getExcluding)).apply((Applicative)codec, BlockMatcher::new));
    public static final BlockMatcher ANY = new BlockMatcher(Optional.empty(), Optional.empty(), Optional.empty()){

        @Override
        public boolean test(BlockState state) {
            return true;
        }
    };

    private Predicate<BlockState> getStatePredicate(String matcher) {
        if (matcher.startsWith("#")) {
            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registry.f_122824_.m_123023_(), (ResourceLocation)new ResourceLocation(matcher.substring(1)));
            return state -> state.m_204336_(tagKey);
        }
        Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(matcher));
        return state -> state.m_60734_() == b;
    }

    public boolean isAny() {
        return this.ifAll.isEmpty() && this.ifAny.isEmpty() && this.excluding.isEmpty();
    }

    private Predicate<BlockState> getNotStatePredicate(String matcher) {
        if (matcher.startsWith("#")) {
            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registry.f_122824_.m_123023_(), (ResourceLocation)new ResourceLocation(matcher.substring(1)));
            return state -> !state.m_204336_(tagKey);
        }
        Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(matcher));
        return state -> state.m_60734_() != b;
    }

    public BlockMatcher(Optional<List<String>> ifAll, Optional<List<String>> ifAny, Optional<List<String>> excluding) {
        this.ifAll = ifAll;
        this.ifAny = ifAny;
        this.excluding = excluding;
        Predicate<BlockState> p = null;
        if (ifAll.isPresent()) {
            for (String string : ifAll.get()) {
                Predicate<BlockState> q = this.getStatePredicate(string);
                if (p == null) {
                    p = q;
                    continue;
                }
                p = p.and(q);
            }
        }
        if (ifAny.isPresent()) {
            Predicate<BlockState> q = null;
            for (String s : ifAny.get()) {
                Predicate<BlockState> sp = this.getStatePredicate(s);
                if (q == null) {
                    q = sp;
                    continue;
                }
                q = q.or(sp);
            }
            if (p == null) {
                p = q;
            } else if (q != null) {
                p = p.and(q);
            }
        }
        if (excluding.isPresent()) {
            for (String string : excluding.get()) {
                Predicate<BlockState> sp = this.getNotStatePredicate(string);
                if (p == null) {
                    p = sp;
                    continue;
                }
                p = p.and(sp);
            }
        }
        this.predicate = p == null ? state -> true : p;
    }

    private Optional<List<String>> getIfAll() {
        return this.ifAll;
    }

    private Optional<List<String>> getIfAny() {
        return this.ifAny;
    }

    private Optional<List<String>> getExcluding() {
        return this.excluding;
    }

    @Override
    public boolean test(BlockState state) {
        return this.predicate.test(state);
    }
}

