/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.structure.jigsaw;

import com.legacy.structure_gel.api.events.RegisterJigsawCapabilityEvent;
import com.legacy.structure_gel.api.registry.SGSimpleRegistry;
import com.legacy.structure_gel.api.structure.ExtendedJigsawStructure;
import com.legacy.structure_gel.core.StructureGelMod;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class JigsawCapability {
    public static final Codec<IJigsawCapability> CODEC = JigsawType.REGISTRY_CODEC.dispatch(IJigsawCapability::getType, JigsawType::getCodec);

    public static interface JigsawType<A extends IJigsawCapability> {
        public static final SGSimpleRegistry<ResourceLocation, JigsawType<?>> REGISTRY = new SGSimpleRegistry(StructureGelMod.locate("jigsaw_type"), () -> VANILLA, RegisterJigsawCapabilityEvent::new);
        public static final Codec<JigsawType<?>> REGISTRY_CODEC = ResourceLocation.f_135803_.flatXmap(key -> Optional.ofNullable(REGISTRY.get((ResourceLocation)key)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown " + REGISTRY.getRegistryName() + " for key " + key + ". Registered: " + REGISTRY.getKeys()))), type -> Optional.ofNullable(REGISTRY.getKey((JigsawType<?>)type)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown " + REGISTRY.getRegistryName() + " for object " + type))));
        public static final JigsawType<?> VANILLA = JigsawType.register("vanilla", () -> Vanilla.CODEC);

        public Codec<A> getCodec();

        private static <A extends IJigsawCapability> JigsawType<A> register(String name, JigsawType<A> type) {
            return JigsawType.register(StructureGelMod.locate(name), type);
        }

        public static <A extends IJigsawCapability> JigsawType<A> register(ResourceLocation name, JigsawType<A> type) {
            return REGISTRY.register(name, type);
        }
    }

    private static final class Vanilla
    implements IJigsawCapability {
        public static final Vanilla INSTANCE = new Vanilla();
        private static final Codec<Vanilla> CODEC = Codec.unit((Object)INSTANCE);

        private Vanilla() {
        }

        @Override
        public JigsawType<?> getType() {
            return JigsawType.VANILLA;
        }

        public String toString() {
            return "Vanilla Capability";
        }
    }

    public static interface IJigsawCapability {
        public JigsawType<?> getType();

        default public boolean canPlace(Structure.GenerationContext generationContext, BlockPos placementPos, ExtendedJigsawStructure.JigsawContext jigsawContext) {
            return true;
        }

        default public ExtendedJigsawStructure.IPieceFactory getPieceFactory() {
            return ExtendedJigsawStructure.IPieceFactory.DEFAULT;
        }

        default public void modifyPieceBuilder(StructurePiecesBuilder pieceBuilder, Structure.GenerationContext context) {
        }
    }
}

