/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.client;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.core.UUIDUtil;
import net.minecraft.resources.ResourceLocation;

public class PlayerTextureRenderer {
    private static final Map<UUID, GameProfile> PROFILES = Maps.newHashMap();

    public static ResourceLocation getTexture(Optional<UUID> optional, MinecraftProfileTexture.Type type) {
        GameProfile profile;
        if (optional.isEmpty()) {
            switch (type) {
                case SKIN: {
                    return DefaultPlayerSkin.m_118626_();
                }
                case ELYTRA: {
                    return new ResourceLocation("textures/entity/elytra.png");
                }
            }
            return null;
        }
        UUID uuid = optional.get();
        PlayerInfo playerinfo = Minecraft.m_91087_().m_91403_().m_104949_(uuid);
        if (playerinfo != null) {
            switch (type) {
                case SKIN: {
                    return playerinfo.m_105337_();
                }
                case CAPE: {
                    return playerinfo.m_105338_();
                }
                case ELYTRA: {
                    ResourceLocation loc = playerinfo.m_105339_();
                    return loc == null ? playerinfo.m_105338_() : loc;
                }
            }
        }
        Minecraft mc = Minecraft.m_91087_();
        if (PROFILES.containsKey(uuid)) {
            profile = PROFILES.get(uuid);
        } else {
            profile = new GameProfile(uuid, null);
            mc.m_91108_().fillProfileProperties(profile, true);
            PROFILES.put(uuid, profile);
        }
        SkinManager manager = mc.m_91109_();
        Map textures = manager.m_118815_(profile);
        if (textures.containsKey(type)) {
            return manager.m_118825_((MinecraftProfileTexture)textures.get(type), type);
        }
        if (type == MinecraftProfileTexture.Type.ELYTRA && textures.containsKey(MinecraftProfileTexture.Type.CAPE)) {
            return manager.m_118825_((MinecraftProfileTexture)textures.get(MinecraftProfileTexture.Type.CAPE), MinecraftProfileTexture.Type.CAPE);
        }
        switch (type) {
            case SKIN: {
                return DefaultPlayerSkin.m_118627_((UUID)UUIDUtil.m_235875_((GameProfile)profile));
            }
            case ELYTRA: {
                return new ResourceLocation("textures/entity/elytra.png");
            }
        }
        return null;
    }

    public static String getSkinType(Optional<UUID> optional) {
        GameProfile profile;
        if (optional.isEmpty()) {
            return "default";
        }
        UUID uuid = optional.get();
        PlayerInfo playerinfo = Minecraft.m_91087_().m_91403_().m_104949_(uuid);
        if (playerinfo != null) {
            return playerinfo.m_105336_();
        }
        Minecraft mc = Minecraft.m_91087_();
        if (PROFILES.containsKey(uuid)) {
            profile = PROFILES.get(uuid);
        } else {
            profile = new GameProfile(uuid, null);
            mc.m_91108_().fillProfileProperties(profile, true);
            PROFILES.put(uuid, profile);
        }
        SkinManager manager = mc.m_91109_();
        Map textures = manager.m_118815_(profile);
        if (textures.containsKey(MinecraftProfileTexture.Type.SKIN)) {
            return ((MinecraftProfileTexture)textures.get(MinecraftProfileTexture.Type.SKIN)).getMetadata("model");
        }
        return DefaultPlayerSkin.m_118629_((UUID)UUIDUtil.m_235875_((GameProfile)profile));
    }
}

