/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.item;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class ArmourSet {
    final String name;
    final Tiers material;
    protected final Map<ArmourType, RegistryObject<ArmorItem>> tools = new HashMap<ArmourType, RegistryObject<ArmorItem>>();

    public ArmourSet(String name, Tiers material, CreativeModeTab tab, DeferredRegister<Item> registry) {
        this(name, material, tab, ArmorItem.class, registry);
    }

    public ArmourSet(String name, Tiers material, CreativeModeTab tab, Class<? extends ArmorItem> clazz, DeferredRegister<Item> registry) {
        this.name = name;
        this.material = material;
        for (ArmourType type : ArmourType.values()) {
            RegistryObject item = registry.register(name + "_" + type.name, () -> type.createItem((Tier)material, tab, null));
            this.tools.put(type, (RegistryObject<ArmorItem>)item);
        }
    }

    public String getName() {
        return this.name;
    }

    public Tier getMaterial() {
        return this.material;
    }

    public ArmorItem getItem(ArmourType type) {
        return (ArmorItem)this.tools.get(type).get();
    }

    public Collection<ArmorItem> getItems() {
        HashSet<ArmorItem> set = new HashSet<ArmorItem>();
        for (RegistryObject<ArmorItem> registry : this.tools.values()) {
            set.add((ArmorItem)registry.get());
        }
        return set;
    }

    public static class ArmourType {
        static Set<ArmourType> REGISTERED_TYPES = new HashSet<ArmourType>();
        public static ArmourType HELMET = ArmourType.register("helmet", EquipmentSlot.HEAD);
        public static ArmourType CHESTPLATE = ArmourType.register("chestplate", EquipmentSlot.CHEST);
        public static ArmourType LEGGINGS = ArmourType.register("leggings", EquipmentSlot.LEGS);
        public static ArmourType BOOTS = ArmourType.register("boots", EquipmentSlot.FEET);
        protected final String name;
        protected final EquipmentSlot slot;

        ArmourType(String name, EquipmentSlot slot) {
            this.name = name;
            this.slot = slot;
        }

        public static Set<ArmourType> values() {
            return REGISTERED_TYPES;
        }

        public static ArmourType register(String name, EquipmentSlot slot) {
            ArmourType type = new ArmourType(name, slot);
            REGISTERED_TYPES.add(type);
            return type;
        }

        public String getName() {
            return this.name;
        }

        public ArmorItem createItem(Tier material, CreativeModeTab tab, Class<? extends ArmorItem> clazz) {
            try {
                ArmorItem item = (ArmorItem)ObfuscationReflectionHelper.findConstructor(clazz, (Class[])new Class[]{Tier.class, EquipmentSlot.class, Item.Properties.class}).newInstance(material, this.slot, new Item.Properties().m_41491_(tab));
                return item;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

