/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.util;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public class RecipeUtils {
    public static boolean compareItemStacks(ItemStack stack1, ItemStack stack2, boolean useNBT) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        if (stack2.m_41720_() == stack1.m_41720_() && stack2.m_41773_() == stack1.m_41773_()) {
            CompoundTag nbt1 = stack1.m_41783_();
            CompoundTag nbt2 = stack2.m_41783_();
            if (nbt1 == null || nbt2 == null) {
                return nbt1 == nbt2;
            }
            return nbt1.equals((Object)nbt2) || !useNBT;
        }
        return false;
    }

    public static boolean compareItemStacksCanFit(ItemStack stack1, ItemStack stack2) {
        if (stack1.m_41619_() || stack2.m_41619_()) {
            return true;
        }
        return RecipeUtils.compareItemStacks(stack1, stack2, true) && stack1.m_41613_() + stack2.m_41613_() <= stack1.m_41741_();
    }

    public static boolean compareItemStacksWithSize(ItemStack stack1, ItemStack stack2, boolean matchExactly) {
        if (RecipeUtils.compareItemStacks(stack1, stack2, true)) {
            if (stack1.m_41613_() == stack2.m_41613_()) {
                return true;
            }
            if (!matchExactly && stack1.m_41613_() < stack2.m_41613_()) {
                return true;
            }
        }
        return false;
    }

    public static boolean canResultsFitInSlots(List<ItemStack> outputList, List<ItemStack> slots, int amount) {
        for (ItemStack out : outputList) {
            amount = RecipeUtils.compareSlots(out, slots, amount);
            if (amount > 0) continue;
            return true;
        }
        return false;
    }

    private static int compareSlots(ItemStack out, List<ItemStack> slots, int amount) {
        for (ItemStack slot : slots) {
            if (!RecipeUtils.compareItemStacksCanFit(out, slot)) continue;
            return amount--;
        }
        for (ItemStack slot : slots) {
            if (!slot.m_41619_()) continue;
            return amount--;
        }
        return amount;
    }
}

