/*
 * Decompiled with CFR 0.152.
 */
package entities;

import block.ModBlocks;
import block.TileEntityForgottenCore;
import com.mialliance.MiCon;
import com.mialliance.ModSounds;
import entities.EntityAbstractLegacy;
import entities.EntityLegacian;
import entities.EntityMi;
import entities.MiSearchGoal;
import item.ModItems;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityRelicoid
extends EntityAbstractLegacy {
    private static final EntityDataAccessor<Integer> DATA_ID_SHIELDING = SynchedEntityData.m_135353_(EntityRelicoid.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_ADVANCING = SynchedEntityData.m_135353_(EntityRelicoid.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_POINTING = SynchedEntityData.m_135353_(EntityRelicoid.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_ID_DEATH = SynchedEntityData.m_135353_(EntityRelicoid.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_ID_DEATH2 = SynchedEntityData.m_135353_(EntityRelicoid.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public ExecuteMovesGoal leapGoal;
    public HurtGoal hurtGoal;
    private int soundTimer = 0;
    private int MoveTimer = 0;
    private int Move = 0;
    private int CombatMoves = 0;
    private boolean inBattle = false;
    private LivingEntity doNotForget = null;
    private boolean isGuardian = false;
    private BlockPos guardianHome;
    protected static final Logger LOGGER = LogManager.getLogger();

    public EntityRelicoid(EntityType<? extends EntityRelicoid> p_i48549_1_, Level p_i48549_2_) {
        super(p_i48549_1_, p_i48549_2_);
        this.f_21364_ = 30;
    }

    protected void m_8099_() {
        this.addBehaviourGoals();
    }

    public void setGuardian(BlockPos po) {
        this.guardianHome = po;
        this.isGuardian = true;
    }

    public boolean m_6785_(double p_213397_1_) {
        return false;
    }

    public void m_7601_(BlockState p_213295_1_, Vec3 p_213295_2_) {
        if (!p_213295_1_.m_60713_(Blocks.f_50033_)) {
            super.m_7601_(p_213295_1_, p_213295_2_);
        }
    }

    protected void addBehaviourGoals() {
        this.leapGoal = new ExecuteMovesGoal(this);
        this.hurtGoal = new HurtGoal(this, new Class[0]);
        this.f_21345_.m_25352_(1, (Goal)new Death(this));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(6, (Goal)new Patrolling(this));
        this.f_21345_.m_25352_(4, (Goal)this.leapGoal);
        this.f_21345_.m_25352_(3, (Goal)new MakeMovesGoal(this));
        this.f_21345_.m_25352_(2, (Goal)this.hurtGoal);
        this.f_21345_.m_25352_(2, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(2, new MiSearchGoal<LivingEntity>((Mob)this, LivingEntity.class, 10, false, false, new TargetPredicate(this)));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.7));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22276_, 85.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22284_, 16.0);
    }

    public void setShield(int p_175463_1_) {
        this.f_19804_.m_135381_(DATA_ID_SHIELDING, (Object)p_175463_1_);
    }

    public boolean isShielding() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_SHIELDING) > 0;
    }

    private void shieldingDown() {
        this.f_19804_.m_135381_(DATA_ID_SHIELDING, (Object)((Integer)this.f_19804_.m_135370_(DATA_ID_SHIELDING) - 1));
    }

    public void setAdvancing(int p_175463_1_) {
        this.f_19804_.m_135381_(DATA_ID_ADVANCING, (Object)p_175463_1_);
    }

    public boolean isAdvancing() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_ADVANCING) > 0;
    }

    private void advancingDown() {
        this.f_19804_.m_135381_(DATA_ID_ADVANCING, (Object)((Integer)this.f_19804_.m_135370_(DATA_ID_ADVANCING) - 1));
    }

    public void setPointing(int p_175463_1_) {
        this.f_19804_.m_135381_(DATA_ID_POINTING, (Object)p_175463_1_);
    }

    public boolean isPointing() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_POINTING) > 0;
    }

    private void pointingDown() {
        this.f_19804_.m_135381_(DATA_ID_POINTING, (Object)((Integer)this.f_19804_.m_135370_(DATA_ID_POINTING) - 1));
    }

    public void setDying() {
        this.f_19804_.m_135381_(DATA_ID_DEATH, (Object)true);
    }

    public boolean isDying() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_DEATH);
    }

    public void setDying2() {
        this.f_19804_.m_135381_(DATA_ID_DEATH2, (Object)true);
    }

    public boolean isDying2() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_DEATH2);
    }

    public boolean m_142535_(float p_149717_, float p_149718_, DamageSource p_149719_) {
        return false;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_SHIELDING, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_ADVANCING, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_POINTING, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_DEATH, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_DEATH2, (Object)false);
    }

    public int m_213860_() {
        return super.m_213860_();
    }

    private List<EntityRelicoid> scanRelicoid() {
        return this.f_19853_.m_6443_(EntityRelicoid.class, this.m_20191_().m_82377_(64.0, 10.0, 64.0), p_226543_1_ -> true);
    }

    private List<TileEntityForgottenCore> scanCores() {
        List all = this.f_19853_.f_151512_;
        ArrayList<TileEntityForgottenCore> cor = new ArrayList<TileEntityForgottenCore>();
        for (TickingBlockEntity e : all) {
            if (!e.m_142280_().equals("mialliance:forgotten_core") || !((double)e.m_142689_().m_123342_() < this.m_20186_() + 6.0) || !((double)e.m_142689_().m_123342_() > this.m_20186_() - 6.0) || !(this.m_20275_(e.m_142689_().m_123341_(), e.m_142689_().m_123342_(), e.m_142689_().m_123343_()) < 40000.0)) continue;
            cor.add((TileEntityForgottenCore)this.f_19853_.m_7702_(e.m_142689_()));
        }
        if (!cor.isEmpty()) {
            return cor;
        }
        return null;
    }

    public void m_8119_() {
        if (this.isShielding()) {
            this.shieldingDown();
        }
        if (this.isAdvancing()) {
            this.advancingDown();
        }
        if (this.isPointing()) {
            this.pointingDown();
        }
        if (this.soundTimer > 0) {
            --this.soundTimer;
        } else if (!this.inBattle && this.m_5448_() != null) {
            this.CombatMoves = 0;
            if (this.m_5448_() instanceof EntityMi || this.m_5448_() instanceof Player) {
                this.inBattle = true;
                this.m_5496_((SoundEvent)ModSounds.RELICOID_GREETING.get(), 2.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
                this.doNotForget = this.m_5448_();
                for (EntityRelicoid rec : this.scanRelicoid()) {
                    rec.soundTimer = 30;
                    rec.inBattle = true;
                    rec.m_6710_(this.m_5448_());
                }
                this.soundTimer = 120;
            }
        } else if (this.m_5448_() == null) {
            if (this.doNotForget != null) {
                this.inBattle = false;
                this.CombatMoves = 0;
            } else {
                this.m_6710_(this.doNotForget);
            }
        }
        super.m_8119_();
    }

    @Override
    public void m_8107_() {
        if (this.isPointing() || this.isDying()) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123809_, this.m_20208_(1.5), this.m_20187_(), this.m_20262_(1.5), 0.0, 0.0, 0.0);
        }
        super.m_8107_();
    }

    protected boolean teleportOffense(Entity p_70816_1_) {
        Vec3 vector3d = new Vec3(this.m_20185_() - p_70816_1_.m_20185_(), this.m_20227_(0.5) - p_70816_1_.m_20188_(), this.m_20189_() - p_70816_1_.m_20189_());
        vector3d = vector3d.m_82541_();
        double d1 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 4.0 - vector3d.f_82479_ * 8.0;
        double d2 = this.m_20186_() + (double)(this.f_19796_.m_188503_(8) - 4) - vector3d.f_82480_ * 8.0;
        double d3 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 4.0 - vector3d.f_82481_ * 8.0;
        return this.teleport(d1, d2, d3);
    }

    private boolean teleport(double p_70825_1_, double p_70825_3_, double p_70825_5_) {
        BlockPos blockpos$mutable = new BlockPos(p_70825_1_, p_70825_3_, p_70825_5_);
        while (blockpos$mutable.m_123342_() > 0 && !this.f_19853_.m_8055_(blockpos$mutable).m_60767_().m_76334_()) {
            blockpos$mutable = blockpos$mutable.m_7495_();
        }
        BlockState blockstate = this.f_19853_.m_8055_(blockpos$mutable);
        boolean flag = blockstate.m_60767_().m_76334_();
        boolean flag1 = blockstate.m_60819_().m_205070_(FluidTags.f_13131_);
        if (flag && !flag1) {
            boolean flag2 = this.m_20984_(p_70825_1_, p_70825_3_, p_70825_5_, true);
            if (flag2 && !this.m_20067_()) {
                this.f_19853_.m_6263_((Player)null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
            }
            return flag2;
        }
        return false;
    }

    private boolean isTargetable(LivingEntity p_test_1_) {
        if (this.isGuardian) {
            if (p_test_1_ instanceof EntityMi) {
                EntityMi mi = (EntityMi)p_test_1_;
                return !mi.isTame() && mi.Weapon != "Train";
            }
            return p_test_1_ instanceof Monster;
        }
        return !(p_test_1_ instanceof EntityRelicoid) && !(p_test_1_ instanceof EntityLegacian);
    }

    @Override
    public boolean m_6469_(DamageSource src, float p_70097_2_) {
        if (this.isShielding()) {
            this.f_19853_.m_6263_((Player)null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11704_, this.m_5720_(), 1.0f, 1.0f);
            return false;
        }
        if (!src.m_19376_() && this.f_19853_.m_213780_().m_188503_(6) == 0) {
            this.f_19853_.m_6263_((Player)null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11704_, this.m_5720_(), 1.0f, 1.0f);
            this.setShield(20);
            return false;
        }
        if (src.m_7639_() instanceof LivingEntity && this.isTargetable((LivingEntity)src.m_7639_())) {
            this.m_6710_((LivingEntity)src.m_7639_());
        }
        if (!super.m_6469_(src, p_70097_2_)) {
            return false;
        }
        return this.f_19853_ instanceof ServerLevel;
    }

    public boolean m_7327_(Entity ta) {
        boolean flag;
        Player playerentity;
        if (ta instanceof Player && (playerentity = (Player)ta).m_21211_().m_41720_() instanceof ShieldItem) {
            playerentity.m_36384_(false);
        }
        if (flag = super.m_7327_(ta)) {
            ((LivingEntity)ta).m_7292_(new MobEffectInstance(MobEffects.f_19614_, 50, 0, true, false));
            ((LivingEntity)ta).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 1, true, false));
        }
        return flag;
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    @Override
    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return SoundEvents.f_12008_;
    }

    @Override
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12059_;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12010_;
    }

    protected void m_7355_(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.m_5496_(this.getStepSound(), 0.45f, 1.0f);
    }

    public void m_213945_(RandomSource source, DifficultyInstance p_180481_1_) {
        super.m_213945_(source, p_180481_1_);
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.FORGOTTEN_BLADE.get()));
    }

    public void m_7380_(CompoundTag cn) {
        cn.m_128379_("isGuardian", this.isGuardian);
        if (this.isGuardian) {
            cn.m_128365_("guardianHome", (Tag)NbtUtils.m_129224_((BlockPos)this.guardianHome));
        }
        super.m_7380_(cn);
    }

    public void m_7378_(CompoundTag cn) {
        this.isGuardian = cn.m_128471_("isGuardian");
        if (this.isGuardian) {
            this.guardianHome = NbtUtils.m_129239_((CompoundTag)cn.m_128469_("guardianHome"));
        }
        super.m_7378_(cn);
    }

    protected float m_6431_(Pose p_213348_1_, EntityDimensions p_213348_2_) {
        return 1.74f;
    }

    public boolean m_7252_(ItemStack p_175448_1_) {
        return super.m_7252_(p_175448_1_);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_213386_1_, DifficultyInstance p_213386_2_, MobSpawnType p_213386_3_, @Nullable SpawnGroupData p_213386_4_, @Nullable CompoundTag p_213386_5_) {
        p_213386_4_ = super.m_6518_(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
        this.m_213945_(p_213386_1_.m_213780_(), p_213386_2_);
        this.m_213946_(p_213386_1_.m_213780_(), p_213386_2_);
        this.m_21051_(Attributes.f_22276_).m_22100_((Double)MiCon.RELICOID_HP_BONUS.get() * this.m_21051_(Attributes.f_22276_).m_22115_());
        this.m_21153_((float)this.m_21051_(Attributes.f_22276_).m_22115_());
        return p_213386_4_;
    }

    public double m_6049_() {
        return -0.45;
    }

    protected void m_7472_(DamageSource p_213333_1_, int p_213333_2_, boolean p_213333_3_) {
        super.m_7472_(p_213333_1_, p_213333_2_, p_213333_3_);
    }

    protected boolean canDestroy(BlockPos min) {
        return !this.f_19853_.m_8055_(min).m_60713_(Blocks.f_50752_) && !this.f_19853_.m_8055_(min).m_204336_(BlockTags.f_144284_) && this.f_19853_.m_6425_(min).m_76178_();
    }

    static class ExecuteMovesGoal
    extends Goal {
        private final EntityRelicoid mob;
        private int CurrentMove;
        private int CurrentMoveTimer;
        private int NoActivateTimer;
        private boolean Activated;
        private Vec3 Charge;
        private BlockPos sealTarget;

        public ExecuteMovesGoal(EntityRelicoid p_i1630_1_) {
            this.mob = p_i1630_1_;
        }

        public boolean m_8036_() {
            return this.mob.Move > 0 && this.mob.m_5448_() != null && !this.mob.isDying();
        }

        public boolean m_8045_() {
            return this.m_8036_() && this.CurrentMove == this.mob.Move && !this.mob.isDying();
        }

        public void m_8056_() {
            this.CurrentMove = this.mob.Move;
            this.CurrentMoveTimer = 0;
            this.NoActivateTimer = 0;
            this.Activated = false;
            this.sealTarget = null;
        }

        public void m_8037_() {
            if (this.Activated) {
                --this.mob.MoveTimer;
                ++this.CurrentMoveTimer;
            } else {
                ++this.NoActivateTimer;
            }
            if (this.mob.MoveTimer < 1) {
                this.mob.Move = 0;
                return;
            }
            if (this.NoActivateTimer > 100) {
                this.mob.Move = 0;
                return;
            }
            if (this.mob.m_5448_() == null) {
                return;
            }
            LivingEntity trt = this.mob.m_5448_();
            RandomSource r = this.mob.f_19796_;
            Boolean startNow = false;
            if (!this.Activated) {
                switch (this.CurrentMove) {
                    case 1: {
                        if (!(this.mob.m_20270_((Entity)trt) < 12.0f)) break;
                        startNow = true;
                        int rr = 80 + r.m_188503_(40);
                        this.mob.setShield(rr);
                        this.mob.m_7292_(new MobEffectInstance(MobEffects.f_19619_, rr, 0, true, false));
                        break;
                    }
                    case 2: {
                        startNow = true;
                        this.mob.setAdvancing(120);
                        this.mob.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 120, 2, true, false));
                        break;
                    }
                    case 3: {
                        if (!this.mob.m_142582_((Entity)trt)) break;
                        startNow = true;
                        break;
                    }
                    case 4: {
                        if (!(this.mob.m_20270_((Entity)trt) > 5.0f) || !(this.mob.m_20270_((Entity)trt) < 12.0f)) break;
                        this.mob.setPointing(100);
                        startNow = true;
                        break;
                    }
                    case 5: {
                        this.mob.setPointing(50);
                        List<TileEntityForgottenCore> co = this.mob.scanCores();
                        if (co == null) {
                            this.CurrentMove = 0;
                            this.mob.Move = 0;
                            break;
                        }
                        double clos = 9999.0;
                        BlockPos p = null;
                        for (TileEntityForgottenCore i : co) {
                            if (!(this.mob.m_5448_().m_20275_((double)i.m_58899_().m_123341_(), (double)i.m_58899_().m_123342_(), (double)i.m_58899_().m_123343_()) < clos)) continue;
                            clos = this.mob.m_5448_().m_20275_((double)i.m_58899_().m_123341_(), (double)i.m_58899_().m_123342_(), (double)i.m_58899_().m_123343_());
                            p = i.m_58899_();
                        }
                        if (p == null) {
                            this.CurrentMove = 0;
                            this.mob.Move = 0;
                            break;
                        }
                        BlockPos o = null;
                        BlockPos rt = null;
                        int i = 0;
                        int t = 0;
                        while (i < 10) {
                            ++i;
                            t = r.m_188503_(4);
                            if (t == 0) {
                                o = p.m_7918_(10, 2, 0);
                                rt = p.m_7918_(20, 0, 0);
                            }
                            if (t == 1) {
                                o = p.m_7918_(-10, 2, 0);
                                rt = p.m_7918_(-20, 0, 0);
                            }
                            if (t == 2) {
                                o = p.m_7918_(0, 2, 10);
                                rt = p.m_7918_(0, 0, 20);
                            }
                            if (t == 3) {
                                o = p.m_7918_(0, 2, -10);
                                rt = p.m_7918_(0, 0, -20);
                            }
                            if (this.mob.f_19853_.m_8055_(rt).m_60713_((Block)ModBlocks.FORGOTTEN_CORE.get())) {
                                if (t < 2) {
                                    if (trt.m_20185_() - (double)o.m_123341_() < 0.0 && this.mob.m_20185_() - (double)o.m_123341_() < 0.0) {
                                        i = 10;
                                    } else if (trt.m_20185_() - (double)o.m_123341_() > 0.0 && this.mob.m_20185_() - (double)o.m_123341_() > 0.0) {
                                        i = 10;
                                    }
                                } else if (trt.m_20189_() - (double)o.m_123343_() < 0.0 && this.mob.m_20189_() - (double)o.m_123343_() < 0.0) {
                                    i = 10;
                                } else if (trt.m_20189_() - (double)o.m_123343_() > 0.0 && this.mob.m_20189_() - (double)o.m_123343_() > 0.0) {
                                    i = 10;
                                }
                            }
                            if (i != 9) continue;
                            i = 25;
                        }
                        if (i == 25) {
                            this.CurrentMove = 0;
                            this.mob.Move = 0;
                            this.mob.MoveTimer = 0;
                            break;
                        }
                        this.sealTarget = o;
                        startNow = true;
                        break;
                    }
                    case 6: {
                        if (!(this.mob.m_20270_((Entity)trt) < 9.0f)) break;
                        this.mob.setPointing(50);
                        startNow = true;
                        break;
                    }
                    case 7: {
                        this.mob.setPointing(50);
                        startNow = true;
                        break;
                    }
                    case 8: {
                        startNow = true;
                        this.mob.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 100, 2, true, false));
                        this.mob.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 200, 2, true, false));
                    }
                }
                if (startNow.booleanValue()) {
                    this.NoActivateTimer = 0;
                    this.Activated = true;
                    if (this.mob.soundTimer < 1 && (this.mob.Move < 6 || this.mob.Move == 7)) {
                        this.mob.m_5496_((SoundEvent)ModSounds.RELICOID_ATTACK.get(), 2.0f, 0.95f + this.mob.f_19796_.m_188501_() * 0.1f);
                        int timer = 60;
                        if (this.mob.isGuardian) {
                            timer = 180;
                        }
                        for (EntityRelicoid rec : this.mob.scanRelicoid()) {
                            rec.soundTimer = timer;
                        }
                        this.mob.soundTimer = timer;
                    }
                    if (this.mob.m_20270_((Entity)trt) < 15.0f) {
                        int sdx = 0;
                        int sdz = 0;
                        sdx = Math.abs(this.mob.m_20185_() - trt.m_20185_()) < 3.0 ? 0 : (this.mob.m_20185_() < trt.m_20185_() ? 1 : -1);
                        sdz = Math.abs(this.mob.m_20189_() - trt.m_20189_()) < 3.0 ? 0 : (this.mob.m_20189_() < trt.m_20189_() ? 1 : -1);
                        boolean hit = false;
                        for (int iy = 0; iy < 3; ++iy) {
                            BlockPos min = this.mob.m_20183_().m_7918_(sdx, iy, sdz);
                            if (this.mob.m_20186_() - trt.m_20186_() > 1.0) {
                                min = trt.m_20183_().m_7918_(0, iy - 2, 0);
                                if (!this.mob.canDestroy(min) || this.mob.f_19853_.m_8055_(min).m_60713_(Blocks.f_50016_)) continue;
                                this.mob.f_19853_.m_46961_(min, true);
                                hit = true;
                                continue;
                            }
                            if (!(this.mob.m_20186_() - trt.m_20186_() < 2.0) && iy != 1 || !this.mob.canDestroy(min) || this.mob.f_19853_.m_8055_(min).m_60713_(Blocks.f_50016_)) continue;
                            this.mob.f_19853_.m_46961_(min, true);
                            hit = true;
                        }
                        if (hit) {
                            this.mob.m_5496_(SoundEvents.f_12601_, 1.0f, 0.9f + this.mob.f_19796_.m_188501_() * 0.2f);
                        }
                    }
                }
            } else {
                switch (this.CurrentMove) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        if (this.CurrentMoveTimer == 10) {
                            this.Charge = new Vec3(trt.m_20185_() - this.mob.m_20185_(), trt.m_20186_() - this.mob.m_20186_(), trt.m_20189_() - this.mob.m_20189_()).m_82541_().m_82542_(0.8, 0.0, 0.8);
                            this.mob.m_20256_(this.Charge);
                        }
                        if (this.CurrentMoveTimer <= 10 || this.CurrentMoveTimer >= 30) break;
                        this.mob.m_20256_(this.Charge);
                        boolean hit = false;
                        for (int ix = -1; ix < 2; ++ix) {
                            for (int iy = 0; iy < 3; ++iy) {
                                for (int iz = -1; iz < 2; ++iz) {
                                    BlockPos min = this.mob.m_20183_().m_7918_(ix, iy, iz);
                                    if (this.mob.f_19853_.m_8055_(min).m_60713_((Block)ModBlocks.FORGOTTEN_BRICKS.get()) || !this.mob.canDestroy(min) || this.mob.f_19853_.m_8055_(min).m_60713_(Blocks.f_50016_)) continue;
                                    this.mob.f_19853_.m_46961_(min, true);
                                    hit = true;
                                }
                            }
                        }
                        if (!hit) break;
                        this.Charge = this.Charge.m_82542_(0.8, 0.8, 0.8);
                        this.mob.m_5496_(SoundEvents.f_12601_, 1.0f, 0.9f + this.mob.f_19796_.m_188501_() * 0.2f);
                        break;
                    }
                    case 4: {
                        if (this.CurrentMoveTimer > 20 && this.CurrentMoveTimer < 30) {
                            BlockPos min;
                            trt.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 10, 5, true, false));
                            BlockPos blockPos = min = r.m_188499_() ? trt.m_20183_().m_7918_(0, 0, -1 + r.m_188503_(3)) : trt.m_20183_().m_7918_(-1 + r.m_188503_(3), 0, 0);
                            if (min != trt.m_20183_() && min != trt.m_20183_() && !this.mob.f_19853_.m_8055_(min).m_60767_().m_76337_()) {
                                while (this.mob.f_19853_.m_8055_(min).m_60713_((Block)ModBlocks.FAMILIAR_LEAVES_GATE.get())) {
                                    min = min.m_7494_();
                                }
                                this.mob.f_19853_.m_7731_(min, ((Block)ModBlocks.FAMILIAR_LEAVES_GATE.get()).m_49966_(), 3);
                            }
                        }
                        if (this.CurrentMoveTimer >= 45) break;
                        this.mob.f_21344_.m_26573_();
                        break;
                    }
                    case 5: {
                        if (this.CurrentMoveTimer > 10 && this.CurrentMoveTimer < 25) {
                            if (this.sealTarget == null) break;
                            BlockPos min = this.sealTarget.m_7918_(-1 + r.m_188503_(3), -1, -1 + r.m_188503_(3));
                            if (this.mob.f_19853_.m_8055_(min).m_60767_().m_76337_()) {
                                min = min.m_7494_();
                            }
                            if (this.mob.f_19853_.m_8055_(min).m_60767_().m_76337_()) {
                                min = min.m_7494_();
                            }
                            if (min != trt.m_20183_() && min != trt.m_20183_().m_7494_() && !this.mob.f_19853_.m_8055_(min).m_60767_().m_76337_()) {
                                this.mob.f_19853_.m_7731_(min, ((Block)ModBlocks.FORGOTTEN_ROCK.get()).m_49966_(), 3);
                            }
                        }
                        if (this.CurrentMoveTimer >= 35) break;
                        this.mob.f_21344_.m_26573_();
                        break;
                    }
                    case 6: {
                        if (this.CurrentMoveTimer == 20) {
                            boolean hit = false;
                            int iy = -1;
                            for (int ix = -1; ix < 2; ++ix) {
                                for (int iz = -1; iz < 2; ++iz) {
                                    BlockPos min = trt.m_20183_().m_7918_(ix, iy, iz);
                                    if (!this.mob.canDestroy(min)) continue;
                                    this.mob.f_19853_.m_46961_(min, true);
                                    hit = true;
                                }
                            }
                            if (hit) {
                                this.mob.m_5496_(SoundEvents.f_12601_, 1.0f, 0.9f + this.mob.f_19796_.m_188501_() * 0.2f);
                            }
                        }
                        if (this.CurrentMoveTimer >= 25) break;
                        this.mob.f_21344_.m_26573_();
                        break;
                    }
                    case 7: {
                        if (this.CurrentMoveTimer == 20) {
                            List<TileEntityForgottenCore> co = this.mob.scanCores();
                            if (co == null) {
                                this.mob.MoveTimer = 0;
                                break;
                            }
                            BlockPos p = co.get(r.m_188503_(co.size())).m_58899_();
                            this.mob.teleport(p.m_123341_(), p.m_123342_() + 1, p.m_123343_());
                            this.mob.m_5634_(10 + r.m_188503_(5));
                        }
                        if (this.CurrentMoveTimer >= 25) break;
                        this.mob.f_21344_.m_26573_();
                    }
                }
            }
        }
    }

    public class HurtGoal
    extends TargetGoal {
        private final TargetingConditions HURT_BY_TARGETING;
        private int timestamp;
        private final Class<?>[] toIgnoreDamage;

        public HurtGoal(EntityRelicoid p_i50317_1_, Class<?> ... p_i50317_2_) {
            super((Mob)p_i50317_1_, true);
            this.HURT_BY_TARGETING = TargetingConditions.m_148352_().m_148355_().m_26893_();
            this.toIgnoreDamage = p_i50317_2_;
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            int i = this.f_26135_.m_21213_();
            LivingEntity livingentity = this.f_26135_.m_21188_();
            if (i != this.timestamp && livingentity != null) {
                for (Class<?> oclass : this.toIgnoreDamage) {
                    if (!oclass.isAssignableFrom(livingentity.getClass())) continue;
                    return false;
                }
                if (((EntityRelicoid)this.f_26135_).isGuardian) {
                    if (livingentity instanceof Player) {
                        return false;
                    }
                    if (livingentity instanceof EntityMi) {
                        return !((EntityMi)livingentity).isTame();
                    }
                }
                return this.m_26150_(livingentity, this.HURT_BY_TARGETING);
            }
            return false;
        }

        public void m_8056_() {
            this.f_26135_.m_6710_(this.f_26135_.m_21188_());
            this.f_26137_ = this.f_26135_.m_5448_();
            this.timestamp = this.f_26135_.m_21213_();
            this.f_26138_ = 300;
            super.m_8056_();
        }
    }

    static class Death
    extends Goal {
        private final EntityRelicoid mob;
        private int Reco = 0;

        public Death(EntityRelicoid p_i1630_1_) {
            this.mob = p_i1630_1_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return this.mob.m_21223_() < 10.0f && !this.mob.m_21224_();
        }

        public boolean m_8045_() {
            return !this.mob.m_21224_();
        }

        public void m_8056_() {
            this.Reco = 0;
            this.mob.m_20331_(true);
            this.mob.setDying();
        }

        public void m_8037_() {
            RandomSource r = this.mob.f_19796_;
            this.Reco += 2;
            if (this.Reco == 20) {
                this.mob.m_5496_((SoundEvent)ModSounds.RELICOID_DEATH.get(), 0.5f, 0.95f + this.mob.f_19796_.m_188501_() * 0.1f);
            }
            if (this.Reco == 50) {
                this.mob.setDying2();
            }
            if (this.Reco == 60) {
                this.mob.m_21205_().m_41774_(1);
            }
            if (this.Reco == 88 || this.Reco == 98 || this.Reco == 108) {
                this.mob.f_19853_.m_46511_((Entity)this.mob, this.mob.m_20185_() + (double)r.m_188501_() - 0.5, this.mob.m_20186_() + (double)(r.m_188501_() * 2.0f), this.mob.m_20189_() + (double)r.m_188501_() - 0.5, 0.5f, Explosion.BlockInteraction.NONE);
            }
            if (this.Reco == 110) {
                this.mob.m_20331_(false);
                if (this.mob.isGuardian) {
                    this.mob.f_19853_.m_7731_(this.mob.m_20183_(), ((Block)ModBlocks.OVERGROWN_METAL.get()).m_49966_(), 3);
                }
                this.mob.m_6667_(DamageSource.f_19319_);
                this.mob.m_142687_(Entity.RemovalReason.KILLED);
            }
        }
    }

    static class Patrolling
    extends Goal {
        private final EntityRelicoid mob;
        private int Reco = 0;
        private BlockPos go = null;
        private Path path = null;
        private BlockPos stuck = null;
        private int stuckCoins = 0;

        public Patrolling(EntityRelicoid p_i1630_1_) {
            this.mob = p_i1630_1_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return this.mob.m_5448_() == null && !this.mob.isDying();
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public void m_8056_() {
            this.Reco = 0;
            this.go = null;
            this.stuck = null;
            this.stuckCoins = 0;
        }

        public void m_8037_() {
            if (this.Reco++ > 20) {
                if (this.mob.m_21223_() < this.mob.m_21233_()) {
                    this.mob.m_5634_(1.0f);
                }
                this.Reco = 0;
                RandomSource r = this.mob.f_19796_;
                if (this.go == null) {
                    if (this.mob.isGuardian) {
                        this.go = this.mob.guardianHome.m_7918_(0, 1, 0);
                        this.Reco = -20;
                    } else {
                        List<TileEntityForgottenCore> co = this.mob.scanCores();
                        if (co == null) {
                            return;
                        }
                        this.go = co.get(r.m_188503_(co.size())).m_58899_().m_7918_(r.m_188503_(7) - 3, 1, r.m_188503_(7) - 3);
                    }
                }
                this.path = this.mob.m_21573_().m_7864_(this.go, 0);
                this.mob.f_21344_.m_26536_(this.path, 1.0);
                if (this.stuck == this.mob.m_20183_()) {
                    ++this.stuckCoins;
                    if (this.stuckCoins > 1 && this.mob.m_20275_(this.go.m_123341_(), this.go.m_123342_(), this.go.m_123343_()) > 2.0) {
                        BlockPos lego = this.go;
                        for (int i = 0; !this.mob.teleport(lego.m_123341_(), lego.m_123342_(), lego.m_123343_()) && i < 10; ++i) {
                            lego = this.go.m_7918_(r.m_188503_(9) - 4, 0, r.m_188503_(9) - 4);
                        }
                    }
                } else {
                    this.stuck = this.mob.m_20183_();
                    this.stuckCoins = 0;
                }
                if (this.mob.m_20275_(this.go.m_123341_(), this.go.m_123342_(), this.go.m_123343_()) < 16.0) {
                    this.go = null;
                }
            }
        }
    }

    static class MakeMovesGoal
    extends Goal {
        private final EntityRelicoid mob;

        public MakeMovesGoal(EntityRelicoid p_i1630_1_) {
            this.mob = p_i1630_1_;
        }

        public boolean m_8036_() {
            return this.mob.Move == 0 && this.mob.m_5448_() != null && !this.mob.isDying();
        }

        public boolean m_8045_() {
            return this.mob.MoveTimer < 1 && !this.mob.isDying();
        }

        public void m_8056_() {
            RandomSource r = this.mob.f_19796_;
            LivingEntity trt = this.mob.m_5448_();
            if (trt == null) {
                return;
            }
            if (this.mob.isGuardian) {
                this.mob.Move = 1 + r.m_188503_(2);
            } else {
                this.mob.Move = 1 + r.m_188503_(5);
                if (this.mob.scanCores() != null && r.m_188503_((int)Math.ceil(this.mob.m_21223_() / 6.0f)) == 0) {
                    this.mob.Move = 7;
                } else if (this.mob.CombatMoves < 2 && this.mob.m_20270_((Entity)trt) > 5.0f && (r.m_188503_(3) == 0 || this.mob.m_20270_((Entity)trt) > 12.0f)) {
                    this.mob.Move = 5;
                } else if (trt.m_20186_() - this.mob.m_20186_() > 8.0) {
                    this.mob.Move = 7;
                } else if (trt.m_20186_() - this.mob.m_20186_() > 3.0) {
                    this.mob.Move = 6;
                } else if (this.mob.m_20270_((Entity)trt) > 14.0f) {
                    this.mob.Move = 3;
                }
            }
            switch (this.mob.Move) {
                case 1: {
                    this.mob.MoveTimer = 35 + r.m_188503_(20);
                    break;
                }
                case 2: {
                    this.mob.MoveTimer = 60 + r.m_188503_(10);
                    break;
                }
                case 3: {
                    this.mob.MoveTimer = 50 + r.m_188503_(20);
                    break;
                }
                case 4: {
                    this.mob.MoveTimer = 80 + r.m_188503_(20);
                    break;
                }
                case 5: {
                    this.mob.MoveTimer = 40 + r.m_188503_(10);
                    ++this.mob.CombatMoves;
                    break;
                }
                case 6: {
                    this.mob.MoveTimer = 30 + r.m_188503_(20);
                    break;
                }
                case 7: {
                    this.mob.MoveTimer = 100;
                    break;
                }
                case 8: {
                    this.mob.MoveTimer = 30 + r.m_188503_(20);
                }
            }
        }

        public void m_8037_() {
        }
    }

    static class TargetPredicate
    implements Predicate<LivingEntity> {
        private final EntityRelicoid re;

        public TargetPredicate(EntityRelicoid rec) {
            this.re = rec;
        }

        @Override
        public boolean test(@Nullable LivingEntity p_test_1_) {
            return this.re.isTargetable(p_test_1_);
        }
    }
}

