/*
 * Decompiled with CFR 0.152.
 */
package entities;

import com.mialliance.MiCon;
import com.mialliance.ModSounds;
import entities.EntityBombimi;
import entities.EntityCorvette;
import entities.EntityLoon;
import entities.EntityMi;
import entities.EntityTonk;
import entities.MiTonkTurretGoal;
import entities.ModEntities;
import item.ModItems;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class EntityTonkTurret
extends EntityMi {
    protected boolean Cannon = false;
    protected EntityLoon Loon;
    protected MiTonkTurretGoal<EntityTonkTurret> TonkTurretGoal = new MiTonkTurretGoal<EntityTonkTurret>(this, 0.5, 50, 35.0f);

    public EntityTonkTurret(EntityType<? extends EntityMi> p_i50195_1_, Level p_i50195_2_) {
        super(p_i50195_1_, p_i50195_2_);
        this.f_21364_ = 10;
    }

    @Override
    public void reassessWeaponGoal() {
        if (this.f_19853_ != null && !this.f_19853_.f_46443_ && !this.isCurrentlyIteratingGoals) {
            this.f_21345_.m_25363_(this.TonkTurretGoal);
            this.f_21345_.m_25352_(4, this.TonkTurretGoal);
        }
    }

    @Override
    protected double getBonus() {
        return (Double)MiCon.TONK_HP_BONUS.get();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 45.0).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22277_, 60.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22284_, 10.0);
    }

    @Override
    public float mi_health_standard() {
        return 45.0f;
    }

    @Override
    public float mi_health_armor1_bonus() {
        return 10.0f;
    }

    @Override
    public float mi_health_armor2_bonus() {
        return 25.0f;
    }

    public void setCannon() {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_41855_));
    }

    public void setFlamethrower() {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.INFERMIUM_FLAMETHROWER.get()));
    }

    public void setAutocannon() {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.BOMBIMI.get()));
    }

    public void setArmament(int ConfigurationID) {
        switch (ConfigurationID) {
            case 1: {
                this.setCannon();
                break;
            }
            case 2: {
                this.setAutocannon();
                break;
            }
            case 3: {
                this.setFlamethrower();
            }
        }
    }

    public boolean isCannon() {
        return this.m_21120_(this.m_7655_()).m_41720_() == ModItems.BOMBIMI.get();
    }

    public boolean isFlamethrower() {
        return this.m_21120_(this.m_7655_()).m_41720_() == ModItems.INFERMIUM_FLAMETHROWER.get();
    }

    public boolean isAutocannon() {
        return this.m_21120_(this.m_7655_()).m_41720_() == Items.f_41855_;
    }

    @Override
    public boolean isObject() {
        return true;
    }

    public int getShellType() {
        if (this.m_20202_() instanceof EntityTonk) {
            if (this.isCannon() && ((EntityTonk)this.m_20202_()).loadedShellID == 0) {
                return 5;
            }
            return ((EntityTonk)this.m_20202_()).loadedShellID;
        }
        if (this.m_20202_() instanceof EntityCorvette) {
            if (this.isCannon() && ((EntityCorvette)this.m_20202_()).loadedShellID == 0) {
                return 5;
            }
            return ((EntityCorvette)this.m_20202_()).loadedShellID;
        }
        return 0;
    }

    public void setShellType(int ID) {
        if (this.m_20202_() instanceof EntityTonk) {
            ((EntityTonk)this.m_20202_()).loadedShellID = ID;
        } else if (this.m_20202_() instanceof EntityCorvette) {
            ((EntityCorvette)this.m_20202_()).loadedShellID = ID;
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
    }

    @Override
    protected SoundEvent m_7515_() {
        return null;
    }

    @Override
    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return SoundEvents.f_12008_;
    }

    @Override
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12313_;
    }

    @Override
    public void m_8107_() {
        if (this.hasActiveAttackTarget()) {
            LivingEntity tar = this.getActiveAttackTarget();
            if (tar != null) {
                double dirx = tar.m_20185_() - this.m_20185_();
                double diry = tar.m_20186_() - this.m_20186_();
                double dirz = tar.m_20189_() - this.m_20189_();
                Vec3 vec = new Vec3(dirx, diry, dirz).m_82541_().m_82542_(0.3, 0.3, 0.3);
                for (int i = 0; i < 18; ++i) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_() + vec.f_82479_, this.m_20186_() + vec.f_82480_, this.m_20189_() + vec.f_82481_, vec.f_82479_ + this.f_19796_.m_188583_() * 0.04 - 0.02, vec.f_82480_ + this.f_19796_.m_188583_() * 0.04 - 0.02, vec.f_82481_ + this.f_19796_.m_188583_() * 0.04 - 0.02);
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_() + vec.f_82479_, this.m_20186_() + vec.f_82480_, this.m_20189_() + vec.f_82481_, vec.f_82479_ + this.f_19796_.m_188583_() * 0.1 - 0.05, vec.f_82480_ + this.f_19796_.m_188583_() * 0.1 - 0.05, vec.f_82481_ + this.f_19796_.m_188583_() * 0.1 - 0.05);
                }
            }
            this.setActiveAttackTarget(0);
        }
        super.m_8107_();
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor p_213386_1_, DifficultyInstance p_213386_2_, MobSpawnType p_213386_3_, @Nullable SpawnGroupData p_213386_4_, @Nullable CompoundTag p_213386_5_) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
        this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Blocks.f_50061_));
        return super.m_6518_(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
    }

    @Override
    protected AbstractArrow getArrow(ItemStack p_213624_1_, float p_213624_2_) {
        AbstractArrow abstractarrowentity = super.getArrow(p_213624_1_, p_213624_2_);
        if (abstractarrowentity instanceof Arrow) {
            ((Arrow)abstractarrowentity).m_36870_(new MobEffectInstance(MobEffects.f_19615_, 10, 0, false, false));
        }
        return abstractarrowentity;
    }

    @Override
    public void m_6504_(LivingEntity p_82196_1_, float p_82196_2_) {
        this.performRangedAttack(p_82196_1_, p_82196_2_, null);
    }

    public void shootAutocannon(LivingEntity trt) {
        float sped;
        RandomSource r = this.f_19796_;
        this.attackCool = 15 + r.m_188503_(5);
        float accuracy = sped = (float)(Math.abs(trt.m_20184_().f_82479_) + Math.abs(trt.m_20184_().f_82480_) + Math.abs(trt.m_20184_().f_82481_)) * 2.0f;
        this.m_5496_(SoundEvents.f_11892_, 1.5f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        if (!this.m_142582_((Entity)trt)) {
            return;
        }
        accuracy = (float)((double)accuracy + 0.1);
        if ((accuracy = (float)((double)accuracy - 0.25 / (double)((float)trt.m_20280_((Entity)this)))) < 0.1f) {
            accuracy = 0.1f;
        }
        if (accuracy > 0.3f) {
            accuracy += 0.3f;
        }
        if (accuracy > 0.75f) {
            accuracy = 0.75f;
        }
        if (this.isTargetFlying(trt)) {
            accuracy -= 0.15f;
        }
        if (r.m_188501_() > accuracy) {
            float dmg = 7.0f - accuracy * 3.0f;
            if (this.isForeign((Entity)this.m_5448_()) || this.isChosen()) {
                dmg *= 1.6f;
            }
            trt.m_6469_(DamageSource.m_19370_((LivingEntity)this), dmg);
        }
        this.setActiveAttackTarget(trt.m_19879_());
    }

    public void ShootFlamethrower(LivingEntity trt) {
        Level wo = this.f_19853_;
        RandomSource r = wo.m_213780_();
        this.m_21563_().m_148051_((Entity)trt);
        this.m_5496_((SoundEvent)ModSounds.SFX_FLAMETHROWER.get(), 4.0f, 0.9f + r.m_188501_() * 0.2f);
        this.setFlaming(true);
        this.setActiveAttackTarget(trt.m_19879_());
        for (LivingEntity tar : this.findVictims(trt)) {
            tar.m_20254_(4);
            float dmg = 3.0f;
            if (this.isForeign((Entity)this.m_5448_())) {
                dmg = 9.0f;
            }
            tar.m_6469_(DamageSource.m_19370_((LivingEntity)this), dmg);
        }
    }

    private List<LivingEntity> findVictims(LivingEntity trt) {
        return this.f_19853_.m_6443_(LivingEntity.class, trt.m_20191_().m_82400_(4.0), cast -> {
            if (cast.m_20147_()) {
                return false;
            }
            if (cast instanceof EntityMi) {
                EntityMi mi = (EntityMi)((Object)cast);
                return mi.getOwner() != this.getOwner();
            }
            return true;
        });
    }

    public void performRangedAttack(LivingEntity p_82196_1_, float p_82196_2_, Vec3 targetvec) {
        int Shell = this.getShellType();
        if (Shell > 1) {
            if (Shell < 6) {
                Vec3 move;
                Level wo = this.f_19853_;
                RandomSource r = this.f_19796_;
                EntityBombimi en = (EntityBombimi)((EntityType)ModEntities.BOMBIMI.get()).m_20615_(wo);
                if (en == null) {
                    return;
                }
                if (this.isTame()) {
                    en.tame(this.getOwnerUUID());
                }
                this.m_5496_(SoundEvents.f_11913_, 16.0f, 1.0f / (this.m_217043_().m_188501_() * 0.2f + 0.6f));
                Vec3 posm = this.m_20182_();
                en.m_20219_(posm.m_82520_(0.0, 1.0, 0.0));
                switch (Shell) {
                    case 2: {
                        en.setShell();
                        break;
                    }
                    case 3: {
                        en.setBreach();
                        break;
                    }
                    case 4: {
                        en.setFlak();
                        break;
                    }
                    case 5: {
                        en.setLightShell();
                    }
                }
                double disto = 0.0;
                if (targetvec == null) {
                    disto = this.m_20270_((Entity)p_82196_1_) / 600.0f;
                }
                if (targetvec != null) {
                    move = targetvec.m_82542_(0.1, 0.1, 0.1);
                } else {
                    Vec3 post = this.m_5448_().m_20182_();
                    double diy = post.f_82480_ - posm.f_82480_ + 2.0;
                    double dix = post.f_82479_ - posm.f_82479_;
                    double diz = post.f_82481_ - posm.f_82481_;
                    if (diy > dix * dix + diz * diz) {
                        diy = dix * dix + diz * diz;
                    }
                    move = new Vec3(dix, diy, diz).m_82542_(0.12 + (double)r.m_188501_() * 0.02, 0.12 + (double)r.m_188501_() * 0.02, 0.12 + (double)r.m_188501_() * 0.02).m_82520_(0.0, disto, 0.0);
                }
                if (move.m_82553_() < 2.1) {
                    move = move.m_82541_().m_82542_(1.5 + (double)r.m_188501_() * 0.2, 1.5 + (double)r.m_188501_() * 0.2, 1.5 + (double)r.m_188501_() * 0.2);
                }
                en.m_20256_(move);
                wo.m_7967_((Entity)en);
                if (this.m_5448_() != null) {
                    this.setActiveAttackTarget(this.m_5448_().m_19879_());
                }
            }
            return;
        }
        ItemStack itemstack = this.m_6298_(this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
        AbstractArrow abstractarrowentity = this.getArrow(itemstack, p_82196_2_);
        if (this.m_21205_().m_41720_() instanceof BowItem) {
            abstractarrowentity = ((BowItem)this.m_21205_().m_41720_()).customArrow(abstractarrowentity);
        }
        double d0 = p_82196_1_.m_20185_() - this.m_20185_();
        double d1 = p_82196_1_.m_20227_(0.3333333333333333) - abstractarrowentity.m_20186_();
        double d2 = p_82196_1_.m_20189_() - this.m_20189_();
        double dist = this.m_20270_((Entity)this.m_5448_()) / 80.0f;
        float spd = 1.6f;
        spd = 3.0f;
        d1 = p_82196_1_.m_20186_() - this.m_20186_();
        dist = dist * 10.0 - 0.25;
        if (d1 < 0.0) {
            d1 *= 1.2;
        }
        abstractarrowentity.m_6686_(d0, d1 + dist, d2, spd, (float)(7 - this.f_19853_.m_46791_().m_19028_() * 2));
        if (Shell == 1 || this.isChosen()) {
            if (!(this.m_5448_() instanceof Player)) {
                abstractarrowentity.m_36781_(8.0);
            } else {
                abstractarrowentity.m_36781_(7.0);
            }
        } else if (!(this.m_5448_() instanceof Player)) {
            if (this.isForeign((Entity)this.m_5448_())) {
                abstractarrowentity.m_36781_(8.0);
            } else {
                abstractarrowentity.m_36781_(6.0);
            }
        } else {
            abstractarrowentity.m_36781_(4.5);
        }
        this.m_5496_(SoundEvents.f_11913_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.setActiveAttackTarget(this.m_5448_().m_19879_());
        this.f_19853_.m_7967_((Entity)abstractarrowentity);
    }
}

