/*
 * Decompiled with CFR 0.152.
 */
package entities;

import block.TileEntityDeclarationBlock;
import com.mialliance.MiCon;
import com.mojang.logging.LogUtils;
import entities.EntityBombimi;
import entities.EntityMi;
import entities.EntityPatrollus;
import entities.EntityPlane;
import entities.EntityTonkTurret;
import entities.EntityTorpimi;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import org.slf4j.Logger;

public abstract class EntityTrain
extends Monster {
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(EntityTrain.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Optional<UUID>> DATA_OWNERUUID_ID = SynchedEntityData.m_135353_(EntityTrain.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public String Objective = null;
    protected int ObjectiveSet;
    public EntityMi ObjectiveCommander = null;
    public BlockPos ObjectiveTarget;
    public BlockPos CheckObjective;
    public BlockPos ObjectiveTarget2;
    public BlockPos CheckObjective2;
    public BlockPos ChestTarget;
    public String Tactic = "";
    public BlockPos TacticPos = null;
    public int TacticTimer = 0;
    public LivingEntity TacticTarget = null;
    public float ObjectiveDirection;
    public int ObjectiveProgress;
    public boolean allowMove = true;
    public boolean canAttack = true;
    public int Stance = 0;
    public BlockPos expeditionTarget = null;
    public BlockPos action = null;
    public int PowerLevel;
    public int missionID = 0;
    public boolean isFriendlyLeader = false;
    public int friendlyFacilityID = 0;
    public int Technique = 0;
    public int specialLeaderID = 0;
    protected int carrySeeds = 0;
    protected int[] carryUpgrades = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public boolean MiridiumArmor = false;
    public boolean InfermiumArmor = false;
    public boolean ForgottenArmor = false;
    public boolean EndimiumArmor = false;
    public boolean doDrops = true;
    public boolean demandFirst = false;
    public int officer_EXP = 0;
    public int officer_Cooldown = -4;
    public int officer_LVL = 0;
    private static final Logger LOGGER = LogUtils.getLogger();

    public boolean CheckPlayerMiHostility(EntityMi mi) {
        if (mi.isTame() != this.isTame()) {
            return true;
        }
        if (!this.isTame()) {
            return false;
        }
        if (!(mi.getOwner() instanceof Player)) {
            return false;
        }
        if (!(this.getOwner() instanceof Player)) {
            return false;
        }
        return this.CheckPlayerHostility((Player)mi.getOwner());
    }

    public boolean CheckPotentialPlayerHostility(Entity liv) {
        if (!(liv instanceof Player)) {
            return true;
        }
        return this.CheckPlayerHostility((Player)liv);
    }

    public boolean CheckPotentialPlayerIfPlayer(Entity liv) {
        if (!(liv instanceof Player)) {
            return false;
        }
        return this.CheckPlayerHostility((Player)liv);
    }

    public boolean CheckPlayerHostility(Player pl) {
        if (!this.isTame()) {
            return true;
        }
        if (this.getOwner() == pl) {
            return false;
        }
        if (this.getOwner() == null) {
            return false;
        }
        List cols = this.f_19853_.f_151512_;
        for (TickingBlockEntity col : cols) {
            if (!col.m_142280_().equals("mialliance:declaration")) continue;
            TileEntityDeclarationBlock blok = (TileEntityDeclarationBlock)this.m_9236_().m_7702_(col.m_142689_());
            if (blok.CustomName.getString().equals(this.getOwner().m_7755_().getString())) {
                for (String str : blok.FindPlayers()) {
                    if (pl.m_7755_().getString().equals(str)) {
                        return true;
                    }
                    if (!str.toLowerCase().equals("all")) continue;
                    return true;
                }
                continue;
            }
            if (!blok.CustomName.getString().equals(pl.m_7755_().getString())) continue;
            for (String str : blok.FindPlayers()) {
                if (this.getOwner().m_7755_().getString().equals(str)) {
                    return true;
                }
                if (!str.toLowerCase().equals("all")) continue;
                return true;
            }
        }
        return false;
    }

    public ArrayList<String> GetPublicEnemies() {
        ArrayList<String> list = new ArrayList<String>();
        return list;
    }

    protected EntityTrain(EntityType<? extends EntityTrain> p_i48574_1_, Level p_i48574_2_) {
        super(p_i48574_1_, p_i48574_2_);
        this.reassessTameGoals();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_OWNERUUID_ID, Optional.empty());
    }

    private boolean isSurrendered() {
        return this.Tactic == "DefiniteSurrender";
    }

    public void m_7380_(CompoundTag p_213281_1_) {
        super.m_7380_(p_213281_1_);
        if (this.getOwnerUUID() != null) {
            p_213281_1_.m_128362_("Owner", this.getOwnerUUID());
        }
        p_213281_1_.m_128405_("ObjectiveProgress", this.ObjectiveProgress);
        p_213281_1_.m_128405_("PowerLevel", this.PowerLevel);
        p_213281_1_.m_128379_("isFriendlyLeader", this.isFriendlyLeader);
        p_213281_1_.m_128379_("Miridium", this.MiridiumArmor);
        p_213281_1_.m_128379_("Infermium", this.InfermiumArmor);
        p_213281_1_.m_128379_("Forgotten", this.ForgottenArmor);
        p_213281_1_.m_128379_("Endimium", this.EndimiumArmor);
        p_213281_1_.m_128379_("Drops", this.doDrops);
        p_213281_1_.m_128379_("canAttack", this.canAttack);
        p_213281_1_.m_128379_("canMove", this.allowMove);
        p_213281_1_.m_128379_("Surrender", this.isSurrendered());
        p_213281_1_.m_128405_("FriendlyFacilityID", this.friendlyFacilityID);
        p_213281_1_.m_128405_("FriendlyMissionID", this.missionID);
        p_213281_1_.m_128405_("Technique", this.Technique);
        p_213281_1_.m_128405_("SpecialLeader", this.specialLeaderID);
        p_213281_1_.m_128350_("ObjectiveDirection", this.ObjectiveDirection);
        p_213281_1_.m_128405_("CarrySeed", this.carrySeeds);
        p_213281_1_.m_128405_("OfficerEXP", this.officer_EXP);
        p_213281_1_.m_128405_("OfficerLVL", this.officer_LVL);
        p_213281_1_.m_128405_("OfficerCOOL", this.officer_Cooldown);
        for (int i = 0; i < this.carryUpgrades.length; ++i) {
            p_213281_1_.m_128405_("CarryUpgrades" + i, this.carryUpgrades[i]);
        }
        if (this.Objective != null) {
            p_213281_1_.m_128359_("ObjectiveA", this.Objective);
        }
        if (this.ObjectiveTarget != null) {
            p_213281_1_.m_128365_("ObjectiveT", (Tag)NbtUtils.m_129224_((BlockPos)this.ObjectiveTarget));
        }
        if (this.ObjectiveTarget2 != null) {
            p_213281_1_.m_128365_("ObjectiveT2", (Tag)NbtUtils.m_129224_((BlockPos)this.ObjectiveTarget2));
        }
        if (this.CheckObjective != null) {
            p_213281_1_.m_128365_("CheckO", (Tag)NbtUtils.m_129224_((BlockPos)this.CheckObjective));
        }
        if (this.CheckObjective2 != null) {
            p_213281_1_.m_128365_("CheckO2", (Tag)NbtUtils.m_129224_((BlockPos)this.CheckObjective2));
        }
        if (this.ChestTarget != null) {
            p_213281_1_.m_128365_("Chest", (Tag)NbtUtils.m_129224_((BlockPos)this.ChestTarget));
        }
        if (this.expeditionTarget != null) {
            p_213281_1_.m_128365_("ExpeditionTarget", (Tag)NbtUtils.m_129224_((BlockPos)this.expeditionTarget));
        }
    }

    public void m_7378_(CompoundTag p_70037_1_) {
        UUID uuid;
        super.m_7378_(p_70037_1_);
        if (p_70037_1_.m_128403_("Owner")) {
            uuid = p_70037_1_.m_128342_("Owner");
        } else {
            String s = p_70037_1_.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
                this.setTame(true);
            }
            catch (Throwable throwable) {
                this.setTame(false);
            }
        }
        this.ObjectiveDirection = p_70037_1_.m_128457_("ObjectiveDirection");
        this.ObjectiveProgress = p_70037_1_.m_128451_("ObjectiveProgress");
        this.PowerLevel = p_70037_1_.m_128451_("PowerLevel");
        this.friendlyFacilityID = p_70037_1_.m_128451_("FriendlyFacilityID");
        this.missionID = p_70037_1_.m_128451_("FriendlyMissionID");
        this.Technique = p_70037_1_.m_128451_("Technique");
        this.specialLeaderID = p_70037_1_.m_128451_("SpecialLeader");
        if (p_70037_1_.m_128471_("Surrender")) {
            this.Tactic = "DefiniteSurrender";
            this.TacticTimer = 14400;
        }
        this.isFriendlyLeader = p_70037_1_.m_128471_("isFriendlyLeader");
        this.MiridiumArmor = p_70037_1_.m_128471_("Miridium");
        this.InfermiumArmor = p_70037_1_.m_128471_("Infermium");
        this.ForgottenArmor = p_70037_1_.m_128471_("Forgotten");
        this.EndimiumArmor = p_70037_1_.m_128471_("Endimium");
        this.canAttack = p_70037_1_.m_128471_("canAttack");
        this.allowMove = p_70037_1_.m_128471_("canMove");
        this.doDrops = p_70037_1_.m_128471_("Drops");
        this.carrySeeds = p_70037_1_.m_128451_("CarrySeed");
        this.officer_EXP = p_70037_1_.m_128451_("OfficerEXP");
        this.officer_LVL = p_70037_1_.m_128451_("OfficerLVL");
        this.officer_Cooldown = p_70037_1_.m_128451_("OfficerCOOL");
        for (int i = 0; i < this.carryUpgrades.length; ++i) {
            this.carryUpgrades[i] = p_70037_1_.m_128451_("CarryUpgrades" + i);
        }
        if (p_70037_1_.m_128461_("ObjectiveA") != null) {
            this.Objective = p_70037_1_.m_128461_("ObjectiveA");
            this.ObjectiveSet = 0;
            switch (this.Objective) {
                case "Point": {
                    this.ObjectiveSet = 1;
                    break;
                }
                case "Guard": {
                    this.ObjectiveSet = 2;
                    break;
                }
                case "Patrol": {
                    this.ObjectiveSet = 3;
                    break;
                }
                case "Follow": {
                    this.ObjectiveSet = 4;
                    break;
                }
                case "Tunnel": {
                    this.ObjectiveSet = 5;
                    break;
                }
                case "TunnelUp": {
                    this.ObjectiveSet = 6;
                    break;
                }
                case "Path": {
                    this.ObjectiveSet = 7;
                    break;
                }
                case "Wall": {
                    this.ObjectiveSet = 8;
                    break;
                }
                case "Road": {
                    this.ObjectiveSet = 9;
                    break;
                }
                case "Colony": {
                    this.ObjectiveSet = 10;
                    break;
                }
                case "Alarm": {
                    this.ObjectiveSet = 11;
                    break;
                }
                case "Scout": {
                    this.ObjectiveSet = 12;
                    break;
                }
                case "Operate": {
                    this.ObjectiveSet = 13;
                    break;
                }
                case "FacilityScout": {
                    this.ObjectiveSet = 16;
                    break;
                }
                case "FacilityGroup": {
                    this.ObjectiveSet = 17;
                    break;
                }
                case "Assassinate": {
                    this.ObjectiveSet = 18;
                    break;
                }
                case "Snipers": {
                    this.ObjectiveSet = 19;
                    break;
                }
                case "Diplomacy": {
                    this.ObjectiveSet = 20;
                }
            }
            if (this.ObjectiveSet > 0) {
                switch (this.ObjectiveSet) {
                    case 1: {
                        this.Objective = "Point";
                        break;
                    }
                    case 2: {
                        this.Objective = "Guard";
                        break;
                    }
                    case 3: {
                        this.Objective = "Patrol";
                        break;
                    }
                    case 4: {
                        this.Objective = "Follow";
                        break;
                    }
                    case 5: {
                        this.Objective = "Tunnel";
                        break;
                    }
                    case 6: {
                        this.Objective = "TunnelUp";
                        break;
                    }
                    case 7: {
                        this.Objective = "Path";
                        break;
                    }
                    case 8: {
                        this.Objective = "Wall";
                        break;
                    }
                    case 9: {
                        this.Objective = "Road";
                        break;
                    }
                    case 10: {
                        this.Objective = "Colony";
                        break;
                    }
                    case 11: {
                        this.Objective = "Alarm";
                        break;
                    }
                    case 12: {
                        this.Objective = "Scout";
                        break;
                    }
                    case 13: {
                        this.Objective = "Operate";
                        break;
                    }
                    case 16: {
                        this.Objective = "FacilityScout";
                        break;
                    }
                    case 17: {
                        this.Objective = "FacilityGroup";
                        break;
                    }
                    case 18: {
                        this.Objective = "Assassinate";
                        break;
                    }
                    case 19: {
                        this.Objective = "Snipers";
                        break;
                    }
                    case 20: {
                        this.Objective = "Diplomacy";
                    }
                }
                this.ObjectiveSet = 0;
            } else {
                this.Objective = null;
            }
        } else {
            this.Objective = null;
        }
        this.ObjectiveTarget = NbtUtils.m_129239_((CompoundTag)p_70037_1_.m_128469_("ObjectiveT")) != null ? NbtUtils.m_129239_((CompoundTag)p_70037_1_.m_128469_("ObjectiveT")) : null;
        this.ObjectiveTarget2 = NbtUtils.m_129239_((CompoundTag)p_70037_1_.m_128469_("ObjectiveT2")) != null ? NbtUtils.m_129239_((CompoundTag)p_70037_1_.m_128469_("ObjectiveT2")) : null;
        this.CheckObjective = NbtUtils.m_129239_((CompoundTag)p_70037_1_.m_128469_("CheckO")) != null ? NbtUtils.m_129239_((CompoundTag)p_70037_1_.m_128469_("CheckO")) : null;
        this.CheckObjective2 = NbtUtils.m_129239_((CompoundTag)p_70037_1_.m_128469_("CheckO2")) != null ? NbtUtils.m_129239_((CompoundTag)p_70037_1_.m_128469_("CheckO2")) : null;
        this.ChestTarget = NbtUtils.m_129239_((CompoundTag)p_70037_1_.m_128469_("Chest")) != null ? NbtUtils.m_129239_((CompoundTag)p_70037_1_.m_128469_("ObjectiveT")) : null;
        if (NbtUtils.m_129239_((CompoundTag)p_70037_1_.m_128469_("ExpeditionTarget")) != null) {
            this.expeditionTarget = NbtUtils.m_129239_((CompoundTag)p_70037_1_.m_128469_("ExpeditionTarget"));
        }
    }

    public boolean m_6573_(Player p_184652_1_) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void spawnTamingParticles(boolean p_70908_1_) {
        for (int i = 0; i < 7; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    protected void m_21424_(Player p_233655_1_, ItemStack p_233655_2_, ItemStack p_233655_3_) {
        if (!p_233655_2_.m_41619_() && !p_233655_3_.m_41619_() && p_233655_3_.m_41720_() == Items.f_42740_) {
            float f = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)this) * 0.05f;
            if (this.f_19796_.m_188501_() < f) {
                p_233655_1_.m_36335_().m_41524_(Items.f_42740_, 100);
                this.f_19853_.m_7605_((Entity)p_233655_1_, (byte)30);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte p_70103_1_) {
        if (p_70103_1_ == 7) {
            this.spawnTamingParticles(true);
        } else if (p_70103_1_ == 6) {
            this.spawnTamingParticles(false);
        } else {
            super.m_7822_(p_70103_1_);
        }
    }

    public boolean isTame() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 4) != 0;
    }

    public void setTame(boolean p_70903_1_) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        if (p_70903_1_) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 | 4)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 & 0xFFFFFFFB)));
        }
        this.reassessTameGoals();
    }

    protected void reassessTameGoals() {
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.f_19804_.m_135370_(DATA_OWNERUUID_ID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID p_184754_1_) {
        this.f_19804_.m_135381_(DATA_OWNERUUID_ID, Optional.ofNullable(p_184754_1_));
    }

    public void tame(Player p_193101_1_) {
        this.setTame(true);
        this.setOwnerUUID(p_193101_1_.m_20148_());
    }

    public void tame(UUID p_193101_1_) {
        this.setTame(true);
        this.setOwnerUUID(p_193101_1_);
    }

    @Nullable
    public LivingEntity getOwner() {
        try {
            UUID uuid = this.getOwnerUUID();
            return uuid == null ? null : this.f_19853_.m_46003_(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public boolean m_6779_(LivingEntity p_213336_1_) {
        return this.isOwnedBy(p_213336_1_) ? false : super.m_6779_(p_213336_1_);
    }

    public boolean isOwnedBy(LivingEntity p_152114_1_) {
        return p_152114_1_ == this.getOwner();
    }

    public boolean wantsToAttack(LivingEntity p_142018_1_, LivingEntity p_142018_2_) {
        return true;
    }

    public boolean m_6935_(Player p_230292_1_) {
        return false;
    }

    public Team m_5647_() {
        LivingEntity livingentity;
        if (this.isTame() && (livingentity = this.getOwner()) != null) {
            return livingentity.m_5647_();
        }
        return super.m_5647_();
    }

    public boolean m_7307_(Entity p_184191_1_) {
        if (this.isTame()) {
            LivingEntity livingentity = this.getOwner();
            if (p_184191_1_ == livingentity) {
                return true;
            }
            if (livingentity != null) {
                return livingentity.m_7307_(p_184191_1_);
            }
        }
        return super.m_7307_(p_184191_1_);
    }

    public void m_6667_(DamageSource p_70645_1_) {
        if (!this.f_19853_.f_46443_ && this.f_19853_.m_46469_().m_46207_(GameRules.f_46142_) && this.getOwner() instanceof ServerPlayer && !(this instanceof EntityBombimi) && !(this instanceof EntityTorpimi)) {
            this.getOwner().m_213846_(this.m_21231_().m_19293_());
        }
        super.m_6667_(p_70645_1_);
    }

    public boolean spawnUnit(EntityType<?> unit, String type, String weapons, Level p_222695_1_, BlockPos p_222695_2_, boolean p_222695_4_) {
        EntityPatrollus patrollerentity = (EntityPatrollus)unit.m_20615_(p_222695_1_);
        if (patrollerentity != null) {
            patrollerentity.MissionType = "Structure";
            patrollerentity.Ammo = 0;
            patrollerentity.Weapon = weapons;
            patrollerentity.Objective = type;
            patrollerentity.ObjectiveTarget = p_222695_2_.m_7495_();
            patrollerentity.m_6034_((double)p_222695_2_.m_123341_() + 0.5, p_222695_2_.m_123342_(), (double)p_222695_2_.m_123343_() + 0.5);
            patrollerentity.m_6518_((ServerLevelAccessor)((ServerLevel)p_222695_1_), p_222695_1_.m_6436_(p_222695_2_), MobSpawnType.STRUCTURE, null, null);
            p_222695_1_.m_7967_((Entity)patrollerentity);
            return true;
        }
        return false;
    }

    public EntityMi spawnMiTarget(EntityType<?> unit, String type, String weapons, Level p_222695_1_, BlockPos p_222695_2_, boolean p_222695_4_) {
        EntityMi patrollerentity = (EntityMi)unit.m_20615_(p_222695_1_);
        if (patrollerentity != null) {
            patrollerentity.MissionType = ((EntityMi)this).MissionType;
            patrollerentity.Ammo = 0;
            patrollerentity.PowerLevel = this.PowerLevel;
            patrollerentity.Weapon = weapons;
            patrollerentity.Objective = type;
            patrollerentity.ObjectiveTarget = p_222695_2_.m_7495_();
            patrollerentity.setColor(((EntityMi)this).getColor());
            if (this.isTame()) {
                patrollerentity.tame(this.getOwnerUUID());
            }
            patrollerentity.m_6034_((double)p_222695_2_.m_123341_() + 0.5, p_222695_2_.m_123342_(), (double)p_222695_2_.m_123343_() + 0.5);
            if (!this.f_19853_.m_5776_()) {
                patrollerentity.m_6518_((ServerLevelAccessor)((ServerLevel)p_222695_1_), p_222695_1_.m_6436_(p_222695_2_), MobSpawnType.PATROL, null, null);
            }
            p_222695_1_.m_7967_((Entity)patrollerentity);
            patrollerentity.equipSelf();
            return patrollerentity;
        }
        return null;
    }

    public EntityMi spawnMiTargetNoChampion(EntityType<?> unit, String type, String weapons, Level p_222695_1_, BlockPos p_222695_2_, boolean p_222695_4_) {
        EntityMi patrollerentity = (EntityMi)unit.m_20615_(p_222695_1_);
        if (patrollerentity != null) {
            patrollerentity.MissionType = ((EntityMi)this).MissionType;
            patrollerentity.Ammo = 0;
            patrollerentity.Weapon = weapons;
            patrollerentity.Objective = type;
            patrollerentity.ObjectiveTarget = p_222695_2_.m_7495_();
            patrollerentity.setColor(((EntityMi)this).getColor());
            if (this.isTame()) {
                patrollerentity.tame(this.getOwnerUUID());
            }
            patrollerentity.m_6034_((double)p_222695_2_.m_123341_() + 0.5, p_222695_2_.m_123342_(), (double)p_222695_2_.m_123343_() + 0.5);
            patrollerentity.m_6518_((ServerLevelAccessor)((ServerLevel)p_222695_1_), p_222695_1_.m_6436_(p_222695_2_), MobSpawnType.PATROL, null, null);
            if (this.MiridiumArmor) {
                patrollerentity.equipMiridium();
            }
            if (this.EndimiumArmor) {
                patrollerentity.equipEndimium();
            }
            p_222695_1_.m_7967_((Entity)patrollerentity);
            return patrollerentity;
        }
        return null;
    }

    public EntityMi spawnMiProjectile(EntityType<?> unit, Level p_222695_1_, Vec3 p_222695_2_, EntityMi spawner) {
        EntityPatrollus patrollerentity = (EntityPatrollus)unit.m_20615_(p_222695_1_);
        if (patrollerentity != null) {
            patrollerentity.m_6034_(p_222695_2_.f_82479_, p_222695_2_.f_82480_, p_222695_2_.f_82481_);
            patrollerentity.m_6518_((ServerLevelAccessor)((ServerLevel)p_222695_1_), p_222695_1_.m_6436_(patrollerentity.m_20183_()), MobSpawnType.STRUCTURE, null, null);
            if (spawner.isTame() && spawner.getOwner() != null) {
                patrollerentity.tame((Player)spawner.getOwner());
            }
            p_222695_1_.m_7967_((Entity)patrollerentity);
            return (EntityMi)patrollerentity;
        }
        return null;
    }

    public EntityMi spawnMount(EntityType<?> unit, Level p_222695_1_, boolean p_222695_4_) {
        EntityMi mi = (EntityMi)this;
        BlockPos pos = mi.m_20183_();
        EntityMi patrollerentity = (EntityMi)unit.m_20615_(p_222695_1_);
        if (patrollerentity != null) {
            patrollerentity.MissionType = mi.MissionType;
            patrollerentity.Ammo = 0;
            patrollerentity.PowerLevel = mi.PowerLevel;
            patrollerentity.Objective = mi.Objective;
            patrollerentity.ObjectiveTarget = mi.ObjectiveTarget;
            patrollerentity.ObjectiveDirection = mi.ObjectiveDirection;
            patrollerentity.setColor(mi.getColor());
            patrollerentity.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            patrollerentity.m_6518_((ServerLevelAccessor)((ServerLevel)p_222695_1_), p_222695_1_.m_6436_(pos), MobSpawnType.PATROL, null, null);
            p_222695_1_.m_7967_((Entity)patrollerentity);
            mi.m_20329_((Entity)patrollerentity);
            if (mi.isTame()) {
                patrollerentity.tame(mi.getOwnerUUID());
            }
            return patrollerentity;
        }
        return null;
    }

    public boolean spawnTurret(EntityType<?> unit, Level p_222695_1_, boolean boss) {
        EntityPatrollus mi = (EntityPatrollus)this;
        BlockPos pos = mi.m_20183_();
        EntityPatrollus patrollerentity = (EntityPatrollus)unit.m_20615_(p_222695_1_);
        if (patrollerentity != null) {
            patrollerentity.MissionType = mi.MissionType;
            if (patrollerentity instanceof EntityPlane) {
                patrollerentity.MissionType = "FighterSquadron";
                ((EntityPlane)patrollerentity).Flying = false;
                if (boss) {
                    patrollerentity.setPatrolLeader(true);
                }
            }
            patrollerentity.PowerLevel = mi.PowerLevel;
            patrollerentity.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            patrollerentity.m_6518_((ServerLevelAccessor)((ServerLevel)p_222695_1_), p_222695_1_.m_6436_(pos), MobSpawnType.PATROL, null, null);
            patrollerentity.m_20329_((Entity)mi);
            p_222695_1_.m_7967_((Entity)patrollerentity);
            return true;
        }
        return false;
    }

    public boolean spawnTurretWithConfiguration(EntityType<?> unit, Level p_222695_1_, int ConfigurationID) {
        EntityPatrollus mi = (EntityPatrollus)this;
        BlockPos pos = mi.m_20183_();
        EntityTonkTurret patrollerentity = (EntityTonkTurret)unit.m_20615_(p_222695_1_);
        if (patrollerentity != null) {
            patrollerentity.MissionType = mi.MissionType;
            patrollerentity.PowerLevel = mi.PowerLevel;
            patrollerentity.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            patrollerentity.m_6518_((ServerLevelAccessor)((ServerLevel)p_222695_1_), p_222695_1_.m_6436_(pos), MobSpawnType.PATROL, null, null);
            patrollerentity.setArmament(ConfigurationID);
            patrollerentity.m_20329_((Entity)mi);
            p_222695_1_.m_7967_((Entity)patrollerentity);
            return true;
        }
        return false;
    }

    public boolean spawnReinforces(EntityType<?> unit, String type, String weapons, Level p_222695_1_, BlockPos p_222695_2_, boolean p_222695_4_) {
        EntityPatrollus patrollerentity = (EntityPatrollus)unit.m_20615_(p_222695_1_);
        if (patrollerentity != null) {
            patrollerentity.MissionType = "Scout";
            patrollerentity.Ammo = 0;
            patrollerentity.Weapon = weapons;
            patrollerentity.Tactic = type;
            patrollerentity.TacticPos = p_222695_2_;
            patrollerentity.m_6034_((double)p_222695_2_.m_123341_() + 0.5, p_222695_2_.m_123342_(), (double)p_222695_2_.m_123343_() + 0.5);
            if (ForgeHooks.canEntitySpawn((Mob)patrollerentity, (LevelAccessor)p_222695_1_, (double)p_222695_2_.m_123341_(), (double)p_222695_2_.m_123342_(), (double)p_222695_2_.m_123343_(), null, (MobSpawnType)MobSpawnType.STRUCTURE) == -1) {
                return false;
            }
            patrollerentity.m_6518_((ServerLevelAccessor)((ServerLevel)p_222695_1_), p_222695_1_.m_6436_(p_222695_2_), MobSpawnType.STRUCTURE, null, null);
            p_222695_1_.m_7967_((Entity)patrollerentity);
            return true;
        }
        return false;
    }

    public SoundSource m_5720_() {
        if (this.isTame()) {
            return SoundSource.NEUTRAL;
        }
        return SoundSource.HOSTILE;
    }

    protected boolean isInFriendlyAttackConfig(LivingEntity ent) {
        return ((ArrayList)MiCon.ALLY_MI_HOSTILES.get()).contains(ent.m_6095_().toString());
    }

    protected boolean isInFriendlyFriendConfig(LivingEntity ent) {
        return ((ArrayList)MiCon.ALLY_MI_FRIENDS.get()).contains(ent.m_6095_().toString());
    }

    protected boolean isInAttackConfig(LivingEntity ent) {
        return ((ArrayList)MiCon.MI_HOSTILES.get()).contains(ent.m_6095_().toString());
    }

    protected boolean isInFriendConfig(LivingEntity ent) {
        return ((ArrayList)MiCon.MI_FRIENDS.get()).contains(ent.m_6095_().toString());
    }
}

