/*
 * Decompiled with CFR 0.152.
 */
package entities;

import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.scores.Team;

public class MiSearchGoal<T extends LivingEntity>
extends Goal {
    protected final Class<T> targetType;
    protected final int randomInterval;
    @Nullable
    protected LivingEntity target;
    protected TargetingConditions targetConditions;
    protected final Mob mob;
    protected final boolean mustSee;
    private final boolean mustReach;
    private int reachCache;
    private int reachCacheTime;
    private int unseenTicks;
    @Nullable
    protected LivingEntity targetMob;
    protected int unseenMemoryTicks = 60;

    public MiSearchGoal(Mob p_26060_, Class<T> p_26061_, boolean p_26062_) {
        this(p_26060_, p_26061_, 10, p_26062_, false, null);
    }

    public MiSearchGoal(Mob p_199891_, Class<T> p_199892_, boolean p_199893_, Predicate<LivingEntity> p_199894_) {
        this(p_199891_, p_199892_, 10, p_199893_, false, p_199894_);
    }

    public MiSearchGoal(Mob p_26064_, Class<T> p_26065_, boolean p_26066_, boolean p_26067_) {
        this(p_26064_, p_26065_, 10, p_26066_, p_26067_, null);
    }

    public MiSearchGoal(Mob p_26053_, Class<T> p_26054_, int p_26055_, boolean p_26056_, boolean p_26057_, @Nullable Predicate<LivingEntity> p_26058_) {
        this.mob = p_26053_;
        this.mustSee = p_26056_;
        this.mustReach = p_26057_;
        this.targetType = p_26054_;
        this.randomInterval = MiSearchGoal.m_186073_((int)p_26055_);
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        this.targetConditions = TargetingConditions.m_148352_().m_26883_(this.getFollowDistance()).m_26888_(p_26058_);
    }

    public boolean m_8036_() {
        if (this.randomInterval > 0 && this.mob.m_217043_().m_188503_(this.randomInterval) != 0) {
            return false;
        }
        this.findTarget();
        return this.target != null;
    }

    protected AABB getTargetSearchArea(double p_26069_) {
        return this.mob.m_20191_().m_82377_(p_26069_, 64.0, p_26069_);
    }

    protected void findTarget() {
        this.target = this.targetType != Player.class && this.targetType != ServerPlayer.class ? this.mob.f_19853_.m_45982_(this.mob.f_19853_.m_6443_(this.targetType, this.getTargetSearchArea(this.getFollowDistance()), p_148152_ -> true), this.targetConditions, (LivingEntity)this.mob, this.mob.m_20185_(), this.mob.m_20188_(), this.mob.m_20189_()) : this.mob.f_19853_.m_45949_(this.targetConditions, (LivingEntity)this.mob, this.mob.m_20185_(), this.mob.m_20188_(), this.mob.m_20189_());
    }

    public void m_8056_() {
        this.mob.m_6710_(this.target);
        this.reachCache = 0;
        this.reachCacheTime = 0;
        this.unseenTicks = 0;
    }

    public void setTarget(@Nullable LivingEntity p_26071_) {
        this.target = p_26071_;
    }

    public boolean m_8045_() {
        LivingEntity livingentity = this.mob.m_5448_();
        double d0 = this.getFollowDistance();
        boolean alerted = false;
        if (livingentity == null) {
            livingentity = this.targetMob;
        } else if (this.mob.m_20280_((Entity)livingentity) < d0 / 2.0 * (d0 / 2.0)) {
            alerted = true;
        }
        if (livingentity == null) {
            return false;
        }
        if (!this.mob.m_6779_(livingentity)) {
            return false;
        }
        Team team = this.mob.m_5647_();
        Team team1 = livingentity.m_5647_();
        if (team != null && team1 == team) {
            return false;
        }
        if (this.mob.m_20280_((Entity)livingentity) > d0 * d0) {
            return false;
        }
        if (this.mustSee && !alerted) {
            if (this.mob.m_21574_().m_148306_((Entity)livingentity)) {
                this.unseenTicks = 0;
            } else if (++this.unseenTicks > MiSearchGoal.m_186073_((int)this.unseenMemoryTicks)) {
                return false;
            }
        }
        this.mob.m_6710_(livingentity);
        return true;
    }

    protected double getFollowDistance() {
        return this.mob.m_21133_(Attributes.f_22277_);
    }

    public void m_8041_() {
        this.mob.m_6710_((LivingEntity)null);
        this.targetMob = null;
    }

    protected boolean canAttack(@Nullable LivingEntity p_26151_, TargetingConditions p_26152_) {
        if (p_26151_ == null) {
            return false;
        }
        if (!p_26152_.m_26885_((LivingEntity)this.mob, p_26151_)) {
            return false;
        }
        if (!this.mob.m_21444_(p_26151_.m_20183_())) {
            return false;
        }
        if (this.mustReach) {
            if (--this.reachCacheTime <= 0) {
                this.reachCache = 0;
            }
            if (this.reachCache == 0) {
                int n = this.reachCache = this.canReach(p_26151_) ? 1 : 2;
            }
            if (this.reachCache == 2) {
                return false;
            }
        }
        return true;
    }

    private boolean canReach(LivingEntity p_26149_) {
        int j;
        this.reachCacheTime = MiSearchGoal.m_186073_((int)(10 + this.mob.m_217043_().m_188503_(5)));
        Path path = this.mob.m_21573_().m_6570_((Entity)p_26149_, 0);
        if (path == null) {
            return false;
        }
        Node node = path.m_77395_();
        if (node == null) {
            return false;
        }
        int i = node.f_77271_ - p_26149_.m_146903_();
        return (double)(i * i + (j = node.f_77273_ - p_26149_.m_146907_()) * j) <= 2.25;
    }

    public MiSearchGoal setUnseenMemoryTicks(int p_26147_) {
        this.unseenMemoryTicks = p_26147_;
        return this;
    }
}

